package com.facebook.thrift.test;

// Generated code
import thrift.test.*;

import com.facebook.thrift.TApplicationException;
import com.facebook.thrift.transport.TTransport;
import com.facebook.thrift.transport.TSocket;
import com.facebook.thrift.transport.THttpClient;
import com.facebook.thrift.transport.TFramedTransport;
import com.facebook.thrift.transport.TTransportException;
import com.facebook.thrift.protocol.TBinaryProtocol;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ArrayList;

/**
 * Test Java client for thrift. Essentially just a copy of the C++ version,
 * this makes a variety of requests to enable testing for both performance and
 * correctness of the output.
 *
 * @author Mark Slee <mcslee@facebook.com>
 */
public class TestClient {
  public static void main(String [] args) {
    try {
      String host = "localhost";
      int port = 9090;
      String url = null;
      int numTests = 1;
      boolean framed = false;
      boolean framedInput = true;
      boolean framedOutput = true;

      try {
        for (int i = 0; i < args.length; ++i) {
          if (args[i].equals("-h")) {
            String[] hostport = (args[++i]).split(":");
            host = hostport[0];
            port = Integer.valueOf(hostport[1]);            
          } else if (args[i].equals("-f") || args[i].equals("-framed")) {
            framed = true;
          } else if (args[i].equals("-fo")) {
            framed = true;
            framedInput = false;
          } else if (args[i].equals("-u")) {
            url = args[++i];
          } else if (args[i].equals("-n")) {
            numTests = Integer.valueOf(args[++i]);
          }
        }
      } catch (Exception x) {
        x.printStackTrace();
      }
      
      TTransport transport;
      
      if (url != null) {
        transport = new THttpClient(url);
      } else {
        TSocket socket = new TSocket(host, port);
        socket.setTimeout(1000);
        transport = socket;
        if (framed) {
          transport = new TFramedTransport(transport,
                                           framedInput,
                                           framedOutput);
        }
      }

      TBinaryProtocol binaryProtocol =
        new TBinaryProtocol(transport);
      ThriftTest.Client testClient =
        new ThriftTest.Client(binaryProtocol);

      long timeMin = 0;
      long timeMax = 0;
      long timeTot = 0;

      for (int test = 0; test < numTests; ++test) {

        /**
         * CONNECT TEST
         */
        System.out.println("Test #" + (test+1) + ", " + "connect " + host + ":" + port);
        try {
          transport.open();
        } catch (TTransportException ttx) {
          System.out.println("Connect failed: " + ttx.getMessage());
          continue;
        }

        long start = System.nanoTime();
    
        /**
         * VOID TEST
         */
        try {
          System.out.print("testVoid()");
          testClient.testVoid();
          System.out.print(" = void\n");
        } catch (TApplicationException tax) {
          tax.printStackTrace();
        }

        /**
         * STRING TEST
         */
        System.out.print("testString(\"Test\")");
        String s = testClient.testString("Test");
        System.out.print(" = \"" + s + "\"\n");

        /**
         * BYTE TEST
         */
        System.out.print("testByte(1)");
        byte i8 = testClient.testByte((byte)1);
        System.out.print(" = " + i8 + "\n");
  
        /**
         * I32 TEST
         */
        System.out.print("testI32(-1)");
        int i32 = testClient.testI32(-1);
        System.out.print(" = " + i32 + "\n");

        /**
         * I64 TEST
         */
        System.out.print("testI64(-34359738368)");
        long i64 = testClient.testI64(-34359738368L);
        System.out.print(" = " + i64 + "\n");

        /**
         * DOUBLE TEST
         */
        System.out.print("testDouble(5.325098235)");
        double dub = testClient.testDouble(5.325098235);
        System.out.print(" = " + dub + "\n");

        /**
         * STRUCT TEST
         */
        System.out.print("testStruct({\"Zero\", 1, -3, -5})");
        Xtruct out = new Xtruct();
        out.string_thing = "Zero";
        out.byte_thing = (byte) 1;
        out.i32_thing = -3;
        out.i64_thing = -5;
        Xtruct in = testClient.testStruct(out);
        System.out.print(" = {" + "\"" + in.string_thing + "\", " + in.byte_thing + ", " + in.i32_thing + ", " + in.i64_thing + "}\n");

        /**
         * NESTED STRUCT TEST
         */
        System.out.print("testNest({1, {\"Zero\", 1, -3, -5}), 5}");
        Xtruct2 out2 = new Xtruct2();
        out2.byte_thing = (short)1;
        out2.struct_thing = out;
        out2.i32_thing = 5;
        Xtruct2 in2 = testClient.testNest(out2);
        in = in2.struct_thing;
        System.out.print(" = {" + in2.byte_thing + ", {" + "\"" + in.string_thing + "\", " + in.byte_thing + ", " + in.i32_thing + ", " + in.i64_thing + "}, " + in2.i32_thing + "}\n");

        /**
         * MAP TEST
         */
        HashMap<Integer,Integer> mapout = new HashMap<Integer,Integer>();
        for (int i = 0; i < 5; ++i) {
          mapout.put(i, i-10);
        }
        System.out.print("testMap({");
        boolean first = true;
        for (int key : mapout.keySet()) {
          if (first) {
            first = false;
          } else {
            System.out.print(", ");
          }
          System.out.print(key + " => " + mapout.get(key));
        }
        System.out.print("})");
        AbstractMap<Integer,Integer> mapin = testClient.testMap(mapout);
        System.out.print(" = {");
        first = true;
        for (int key : mapin.keySet()) {
          if (first) {
            first = false;
          } else {
            System.out.print(", ");
          }
          System.out.print(key + " => " + mapout.get(key));
        }
        System.out.print("}\n");

        /**
         * SET TEST
         */
        HashSet<Integer> setout = new HashSet<Integer>();
        for (int i = -2; i < 3; ++i) {
          setout.add(i);
        }
        System.out.print("testSet({");
        first = true;
        for (int elem : setout) {
          if (first) {
            first = false;
          } else {
            System.out.print(", ");
          }
          System.out.print(elem);
        }
        System.out.print("})");
        HashSet<Integer> setin = testClient.testSet(setout);
        System.out.print(" = {");
        first = true;
        for (int elem : setin) {
          if (first) {
            first = false;
          } else {
            System.out.print(", ");
          }
          System.out.print(elem);
        }
        System.out.print("}\n");

        /**
         * LIST TEST
         */
        ArrayList<Integer> listout = new ArrayList<Integer>();
        for (int i = -2; i < 3; ++i) {
          listout.add(i);
        }
        System.out.print("testList({");
        first = true;
        for (int elem : listout) {
          if (first) {
            first = false;
          } else {
            System.out.print(", ");
          }
          System.out.print(elem);
        }
        System.out.print("})");
        ArrayList<Integer> listin = testClient.testList(listout);
        System.out.print(" = {");
        first = true;
        for (int elem : listin) {
          if (first) {
            first = false;
          } else {
            System.out.print(", ");
          }
          System.out.print(elem);
        }
        System.out.print("}\n");

        /**
         * ENUM TEST
         */
        System.out.print("testEnum(ONE)");
        int ret = testClient.testEnum(Numberz.ONE);
        System.out.print(" = " + ret + "\n");

        System.out.print("testEnum(TWO)");
        ret = testClient.testEnum(Numberz.TWO);
        System.out.print(" = " + ret + "\n");

        System.out.print("testEnum(THREE)");
        ret = testClient.testEnum(Numberz.THREE);
        System.out.print(" = " + ret + "\n");

        System.out.print("testEnum(FIVE)");
        ret = testClient.testEnum(Numberz.FIVE);
        System.out.print(" = " + ret + "\n");

        System.out.print("testEnum(EIGHT)");
        ret = testClient.testEnum(Numberz.EIGHT);
        System.out.print(" = " + ret + "\n");

        /**
         * TYPEDEF TEST
         */
        System.out.print("testTypedef(309858235082523)");
        long uid = testClient.testTypedef(309858235082523L);
        System.out.print(" = " + uid + "\n");

        /**
         * NESTED MAP TEST
         */
        System.out.print("testMapMap(1)");
        AbstractMap<Integer,AbstractMap<Integer,Integer>> mm =
          testClient.testMapMap(1);
        System.out.print(" = {");
        for (int key : mm.keySet()) {
          System.out.print(key + " => {");
          AbstractMap<Integer,Integer> m2 = mm.get(key);
          for (int k2 : m2.keySet()) {
            System.out.print(k2 + " => " + m2.get(k2) + ", ");
          }
          System.out.print("}, ");
        }
        System.out.print("}\n");

        /**
         * INSANITY TEST
         */
        Insanity insane = new Insanity();
        insane.userMap = new HashMap<Integer, Long>();
        insane.userMap.put(Numberz.FIVE, (long)5000);
        Xtruct truck = new Xtruct();
        truck.string_thing = "Truck";
        truck.byte_thing = (byte)8;
        truck.i32_thing = 8;
        truck.i64_thing = 8;
        insane.xtructs = new ArrayList<Xtruct>();
        insane.xtructs.add(truck);
        System.out.print("testInsanity()");
        AbstractMap<Long,AbstractMap<Integer,Insanity>> whoa =
          testClient.testInsanity(insane);
        System.out.print(" = {");
        for (long key : whoa.keySet()) {
          AbstractMap<Integer,Insanity> val = whoa.get(key);
          System.out.print(key + " => {");

          for (int k2 : val.keySet()) {
            Insanity v2 = val.get(k2);
            System.out.print(k2 + " => {");
            AbstractMap<Integer, Long> userMap = v2.userMap;
            System.out.print("{");
            if (userMap != null) {
              for (int k3 : userMap.keySet()) {
                System.out.print(k3 + " => " + userMap.get(k3) + ", ");
              }
            }
            System.out.print("}, ");

            ArrayList<Xtruct> xtructs = v2.xtructs;
            System.out.print("{");
            if (xtructs != null) {
              for (Xtruct x : xtructs) {
                System.out.print("{" + "\"" + x.string_thing + "\", " + x.byte_thing + ", " + x.i32_thing + ", "+ x.i64_thing + "}, ");
              }
            }
            System.out.print("}");

            System.out.print("}, ");
          }
          System.out.print("}, ");
        }
        System.out.print("}\n");

        long stop = System.nanoTime();
        long tot = stop-start;

        System.out.println("Total time: " + tot/1000 + "us");

        if (timeMin == 0 || tot < timeMin) {
          timeMin = tot;
        }
        if (tot > timeMax) {
          timeMax = tot;
        }
        timeTot += tot;

        transport.close();
      }

      long timeAvg = timeTot / numTests;
      
      System.out.println("Min time: " + timeMin/1000 + "us");
      System.out.println("Max time: " + timeMax/1000 + "us");
      System.out.println("Avg time: " + timeAvg/1000 + "us");
            
    } catch (Exception x) {
      x.printStackTrace();
    }  

  }

}
