package com.supwisdom.dlpay.consume.dao;

import com.supwisdom.dlpay.consume.domain.TDpsdtl;
import com.supwisdom.dlpay.framework.data.VoucherTemp;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Repository
public interface DpsdtlDao extends JpaRepository<TDpsdtl, String> {

  @Query(value = "select a.drsubjno,a.crsubjno,a.summary,count(t.refno) as transcnt,sum(t.dpsamt) as transamt " +
      "from tb_dpsdtl t left join tb_transtype a on t.transtype=a.transtype " +
      "where t.status='success' and t.accdate=:settledate " +
      "group by a.drsubjno,a.crsubjno,a.summary ", nativeQuery = true)
  List<VoucherTemp> getVoucherData(@RequestParam("settledate") String settledate);

  @Query(value = "select a.drsubjno,a.crsubjno,a.summary,count(t.refno) as transcnt,sum(t.feeamt) as transamt " +
      "from tb_dpsdtl t left join tb_feetype_config a on t.feetype=a.feetype and t.paytype=a.paytype " +
      "where t.status='success' and t.feetype!='none' and t.accdate=:settledate " +
      "group by a.drsubjno,a.crsubjno,a.summary ", nativeQuery = true)
  List<VoucherTemp> getFeeVoucherData(@RequestParam("settledate") String settledate);
}
