package com.supwisdom.dlpay.consume.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "TB_TRANSDTL")
public class TTransdtl {
  @Id
  @Column(name = "REFNO", nullable = false, length = 32)
  private String refno;

  @Column(name = "ACCDATE", length = 8)
  private String accdate;

  @Column(name = "ACCNO", length = 32)
  private String accno;

  @Column(name = "PAYTYPE", length = 20)
  private String paytype; //支付方式 balance,wechat,alipay

  @Column(name = "PAYINFO", length = 200)
  private String payinfo; //记录支付信息备用字段

  @Column(name = "AMOUNT", precision = 9, scale = 2)
  private Double amount;

  @Column(name = "PAIDAMT", precision = 9, scale = 2)
  private Double paidamt;

  @Column(name = "FEETYPE", length = 20)
  private String feetype="none"; //费用类型

  @Column(name = "FEEAMT", precision = 9, scale = 2)
  private Double feeamt=0D;  //费用金额

  @Column(name = "STATUS", length = 20)
  private String status;

  @Column(name = "BEFBAL", precision = 9, scale = 2)
  private Double befbal;

  @Column(name = "AFTBAL", precision = 9, scale = 2)
  private Double aftbal;

  @Column(name = "SHOPACCNO", length = 32)
  private String shopaccno;

  @Column(name = "TRANSCODE", precision = 4)
  private Integer transcode; //指定交易类型

  @Column(name = "TRANSTYPE", precision = 4)
  private Integer transtype; //指定借贷双方

  @Column(name = "TRANSDESC", length = 240)
  private String transdesc;

  @Column(name = "CREATETIME", length = 14)
  private String createtime;

  @Column(name = "ENDTIME", length = 14)
  private String endtime;

  @Column(name = "OUTTRADENO", length = 60)
  private String outtradeno;

  @Column(name = "TRANSDATE", length = 8)
  private String transdate;

  @Column(name = "TRANSTIME", length = 6)
  private String transtime;

  @Column(name = "REVFLAG", nullable = false, precision = 1)
  private Integer revflag = 0;

  @Column(name="REMARK", length = 240)
  private String remark;

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public String getAccno() {
    return accno;
  }

  public void setAccno(String accno) {
    this.accno = accno;
  }

  public String getPaytype() {
    return paytype;
  }

  public void setPaytype(String paytype) {
    this.paytype = paytype;
  }

  public String getPayinfo() {
    return payinfo;
  }

  public void setPayinfo(String payinfo) {
    this.payinfo = payinfo;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public Double getPaidamt() {
    return paidamt;
  }

  public void setPaidamt(Double paidamt) {
    this.paidamt = paidamt;
  }

  public String getFeetype() {
    return feetype;
  }

  public void setFeetype(String feetype) {
    this.feetype = feetype;
  }

  public Double getFeeamt() {
    return feeamt;
  }

  public void setFeeamt(Double feeamt) {
    this.feeamt = feeamt;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Double getBefbal() {
    return befbal;
  }

  public void setBefbal(Double befbal) {
    this.befbal = befbal;
  }

  public Double getAftbal() {
    return aftbal;
  }

  public void setAftbal(Double aftbal) {
    this.aftbal = aftbal;
  }

  public String getShopaccno() {
    return shopaccno;
  }

  public void setShopaccno(String shopaccno) {
    this.shopaccno = shopaccno;
  }

  public Integer getTranscode() {
    return transcode;
  }

  public void setTranscode(Integer transcode) {
    this.transcode = transcode;
  }

  public Integer getTranstype() {
    return transtype;
  }

  public void setTranstype(Integer transtype) {
    this.transtype = transtype;
  }

  public String getTransdesc() {
    return transdesc;
  }

  public void setTransdesc(String transdesc) {
    this.transdesc = transdesc;
  }

  public String getCreatetime() {
    return createtime;
  }

  public void setCreatetime(String createtime) {
    this.createtime = createtime;
  }

  public String getEndtime() {
    return endtime;
  }

  public void setEndtime(String endtime) {
    this.endtime = endtime;
  }

  public String getOuttradeno() {
    return outtradeno;
  }

  public void setOuttradeno(String outtradeno) {
    this.outtradeno = outtradeno;
  }

  public String getTransdate() {
    return transdate;
  }

  public void setTransdate(String transdate) {
    this.transdate = transdate;
  }

  public String getTranstime() {
    return transtime;
  }

  public void setTranstime(String transtime) {
    this.transtime = transtime;
  }

  public Integer getRevflag() {
    return revflag;
  }

  public void setRevflag(Integer revflag) {
    this.revflag = revflag;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }
}
