package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.AmountBean;
import com.supwisdom.dlpay.framework.domain.TShopaccday;
import com.supwisdom.dlpay.framework.domain.TShopaccdayPK;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Repository
public interface ShopaccdayDao extends JpaRepository<TShopaccday, TShopaccdayPK> {

  @Query(value = "from TShopaccday t where t.accdate=:accdate ")
  List<TShopaccday> getShopaccdayByAccdate(@RequestParam("accdate") String accdate);

  @Query(value = "from TShopaccday t where t.accdate=:accdate and t.shopaccno=:shopaccno ")
  TShopaccday getTShopaccdayById(@RequestParam("accdate") String accdate, @RequestParam("shopaccno") String shopaccno);

  @Query(value = "update TShopaccday set balance=beginbal-dramt+cramt,updtime=:updtime where accdate=:accdate ")
  void updateShopaccdayBalance(@RequestParam("accdate") String accdate,@RequestParam("updtime")String updtime);

  @Query(value = "select sum(balance) as amount from TShopaccday where accdate=:accdate ")
  AmountBean getSumBalance(@RequestParam("accdate") String accdate);

}
