package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.AccnameBean;
import com.supwisdom.dlpay.framework.data.AccnoBean;
import com.supwisdom.dlpay.framework.data.ExistBean;
import com.supwisdom.dlpay.framework.domain.TSubject;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Repository
public interface SubjectDao extends JpaRepository<TSubject, String> {

  @Query(value = "select t.SUBJNO as accno from TB_SUBJECT t left join TB_SUBJECTBAL a on t.SUBJNO=a.SUBJNO where t.ENDFLAG=1 and a.SUBJNO is null ", nativeQuery = true)
  List<AccnoBean> getNewSubject();

  @Query(value = "select count(t.*) as existed from TB_SUBJECT t left join TB_SUBJECTBAL a on t.SUBJNO=a.SUBJNO where t.ENDFLAG=1 and a.SUBJNO is null ", nativeQuery = true)
  ExistBean checkSettleSubject();

  @Query(value = "select a.subjno as accno from TB_SUBJECT a left join (select subjno from TB_SUBJECTDAY where accdate =:accdate ) b on a.subjno=b.subjno where a.subjlevel=1 and b.subjno is null ", nativeQuery = true)
  List<AccnoBean> getNewSubjnos(@RequestParam("accdate") String accdate);

  @Query(value = "select subjname from TSubject where subjno=:subjno ")
  AccnameBean getSubjectname(@RequestParam("subjno") String subjno);
}
