package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.ExistBean;
import com.supwisdom.dlpay.framework.data.MerchBean;
import com.supwisdom.dlpay.framework.domain.TVoucher;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.web.bind.annotation.RequestParam;

import javax.persistence.LockModeType;
import java.util.List;

public interface VoucherDao extends JpaRepository<TVoucher, String> {

  @Query(value = "select count(t.*) as existed from TB_VOUCHER t where t.POSTFLAG=0 and t.SOURCETYPE!='auto' ", nativeQuery = true)
  ExistBean checkExistUnpostVouhcer();

  @Query(value="delete from TB_VOUCHER where POSTFLAG=0 ",nativeQuery = true)
  void deleteUnpostVoucher();

  @Lock(LockModeType.PESSIMISTIC_FORCE_INCREMENT)
  @Query(value = "from TVoucher where postflag=0 order by voucherid ")
  List<TVoucher> getSettleVouchers();

  @Query(value="select va.accno as shopaccno,sum(va.dramt) as dramt,sum(va.cramt) as cramt " +
      "from tb_voucherentry va,tb_voucher vb " +
      "where va.voucherid=vb.voucherid and vb.voucherdate=:settledate and va.subjno='2004' and va.accno is not null " +
      "group by va.accno order by va.accno ", nativeQuery = true)
  List<MerchBean> getShopVoucherByAccdate(@RequestParam("settledate")Integer settledate);

  @Query(value = "select sum(va.dramt) as dramt, sum(va.cramt) as cramt  from TB_VOUCHERENTRY va,TB_VOUCHER vb where va.voucherid=vb.voucherid and vb.voucherdate=:voucherdate and va.subjno=:subjno ", nativeQuery = true)
  MerchBean getSettleSuminfo(@RequestParam("voucherdate") Integer voucherdate, @RequestParam("subjno") String subjno);
}
