package com.supwisdom.dlpay.framework.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Entity
@Table(name = "TB_VOUCHER")
public class TVoucher {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name="VOUCHERID", nullable = false, length = 32)
  private String voucherid;

  @Column(name="PERIOD_YEAR", precision = 8)
  private Integer periodYear;

  @Column(name="PERIOD_MONTH", precision = 2)
  private Integer periodMonth;

  @Column(name="VOUCHERNO", precision = 9)
  private Integer voucherno;

  @Column(name="VOUCHERDATE", precision = 8)
  private Integer voucherdate;

  @Column(name="TRANSDATE", precision = 8)
  private Integer transdate;

  @Column(name="TRANSCNT", precision = 9)
  private Integer transcnt;

  @Column(name="AMOUNT", precision = 15, scale = 2)
  private Double amount;

  @Column(name="SUMMARY", length = 200)
  private String summary;

  @Column(name="ENTRYCNT", precision = 2)
  private Integer entrycnt=2;

  @Column(name="ATTACHMENTS", precision = 1)
  private Integer attachments;

  @Column(name="SOURCETYPE", length = 20)
  private String sourcetype;

  @Column(name="SIGNFLAG", precision = 1)
  private Integer signflag;

  @Column(name="CHECKFLAG", precision =1)
  private Integer checkflag;

  @Column(name="POSTFLAG", precision = 1)
  private Integer postflag;

  @Column(name="INVALIDFLAG", precision =1)
  private Integer invalidflag;

  @Column(name="EDITFLAG", precision =1)
  private Integer editflag;

  @Column(name="PREPARER", length = 32)
  private String preparer;

  @Column(name="CASHIER", length = 32)
  private String cashier;

  @Column(name="CHECKER", length = 32)
  private String checker;

  @Column(name="POSTER", length = 32)
  private String poster;

  @Column(name="CREATEDATE", precision =8)
  private Integer createdate;

  public TVoucher(Integer periodYear, Integer periodMonth, Integer voucherno, Integer voucherdate, Integer transdate, Integer transcnt, Double amount, String summary, String sourcetype, Integer createdate) {
    this.periodYear = periodYear;
    this.periodMonth = periodMonth;
    this.voucherno = voucherno;
    this.voucherdate = voucherdate;
    this.transdate = transdate;
    this.transcnt = transcnt;
    this.amount = amount;
    this.summary = summary;
    this.entrycnt = 2;
    this.attachments = 0;
    this.sourcetype = sourcetype;
    this.signflag = 0;
    this.checkflag = 1;
    this.postflag = 0;
    this.invalidflag = 0;
    this.editflag = 0;
    this.createdate = createdate;
  }

  public TVoucher(Integer periodYear, Integer periodMonth, Integer voucherno, Integer voucherdate, Integer transdate, Integer transcnt, Double amount, String summary, Integer entrycnt, Integer attachments, String sourcetype, Integer signflag, Integer checkflag, Integer postflag, Integer invalidflag, Integer editflag, String preparer, String cashier, String checker, String poster, Integer createdate) {
    this.periodYear = periodYear;
    this.periodMonth = periodMonth;
    this.voucherno = voucherno;
    this.voucherdate = voucherdate;
    this.transdate = transdate;
    this.transcnt = transcnt;
    this.amount = amount;
    this.summary = summary;
    this.entrycnt = entrycnt;
    this.attachments = attachments;
    this.sourcetype = sourcetype;
    this.signflag = signflag;
    this.checkflag = checkflag;
    this.postflag = postflag;
    this.invalidflag = invalidflag;
    this.editflag = editflag;
    this.preparer = preparer;
    this.cashier = cashier;
    this.checker = checker;
    this.poster = poster;
    this.createdate = createdate;
  }

  public String getVoucherid() {
    return voucherid;
  }

  public void setVoucherid(String voucherid) {
    this.voucherid = voucherid;
  }

  public Integer getPeriodYear() {
    return periodYear;
  }

  public void setPeriodYear(Integer periodYear) {
    this.periodYear = periodYear;
  }

  public Integer getPeriodMonth() {
    return periodMonth;
  }

  public void setPeriodMonth(Integer periodMonth) {
    this.periodMonth = periodMonth;
  }

  public Integer getVoucherno() {
    return voucherno;
  }

  public void setVoucherno(Integer voucherno) {
    this.voucherno = voucherno;
  }

  public Integer getVoucherdate() {
    return voucherdate;
  }

  public void setVoucherdate(Integer voucherdate) {
    this.voucherdate = voucherdate;
  }

  public Integer getTransdate() {
    return transdate;
  }

  public void setTransdate(Integer transdate) {
    this.transdate = transdate;
  }

  public Integer getTranscnt() {
    return transcnt;
  }

  public void setTranscnt(Integer transcnt) {
    this.transcnt = transcnt;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public String getSummary() {
    return summary;
  }

  public void setSummary(String summary) {
    this.summary = summary;
  }

  public Integer getEntrycnt() {
    return entrycnt;
  }

  public void setEntrycnt(Integer entrycnt) {
    this.entrycnt = entrycnt;
  }

  public Integer getAttachments() {
    return attachments;
  }

  public void setAttachments(Integer attachments) {
    this.attachments = attachments;
  }

  public String getSourcetype() {
    return sourcetype;
  }

  public void setSourcetype(String sourcetype) {
    this.sourcetype = sourcetype;
  }

  public Integer getSignflag() {
    return signflag;
  }

  public void setSignflag(Integer signflag) {
    this.signflag = signflag;
  }

  public Integer getCheckflag() {
    return checkflag;
  }

  public void setCheckflag(Integer checkflag) {
    this.checkflag = checkflag;
  }

  public Integer getPostflag() {
    return postflag;
  }

  public void setPostflag(Integer postflag) {
    this.postflag = postflag;
  }

  public Integer getInvalidflag() {
    return invalidflag;
  }

  public void setInvalidflag(Integer invalidflag) {
    this.invalidflag = invalidflag;
  }

  public Integer getEditflag() {
    return editflag;
  }

  public void setEditflag(Integer editflag) {
    this.editflag = editflag;
  }

  public String getPreparer() {
    return preparer;
  }

  public void setPreparer(String preparer) {
    this.preparer = preparer;
  }

  public String getCashier() {
    return cashier;
  }

  public void setCashier(String cashier) {
    this.cashier = cashier;
  }

  public String getChecker() {
    return checker;
  }

  public void setChecker(String checker) {
    this.checker = checker;
  }

  public String getPoster() {
    return poster;
  }

  public void setPoster(String poster) {
    this.poster = poster;
  }

  public Integer getCreatedate() {
    return createdate;
  }

  public void setCreatedate(Integer createdate) {
    this.createdate = createdate;
  }
}
