package com.supwisdom.dlpay.doorlist.controller;

import cn.afterturn.easypoi.entity.vo.NormalExcelConstants;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.view.PoiBaseView;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.bean.TDoorcardlstInfo;
import com.supwisdom.dlpay.mainservice.domain.TKey;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.system.domain.TDictionaryId;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.SystemService;
import com.supwisdom.dlpay.util.RedisUtil;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/doorlistMgr")
public class DoorlistMgrController {

    protected static Logger logger = Logger.getLogger(DoorlistMgrController.class);

    @Autowired
    SystemService systemService;
    @Autowired
    WebInterfaceService webInterfaceService;
    @Autowired
    NcService ncService;

    @RequestMapping("/downDoorList")
    public String downDoorList(ModelMap model){
        return "doorlist/addDoorlist";
    }

    @RequestMapping("/deleteDoorList")
    public String deleteDoorList(ModelMap model){
        return "doorlist/deleteDoorlist";
    }

    @RequestMapping("/searchDoorlist")
    public String searchDoorlist(ModelMap model){
        return "doorlist/searchDoorlist";
    }

    /**
     * 填充查询门禁列表下拉菜单
     * @return
     * @throws Exception
     */
    @ResponseBody
    @RequestMapping(value = "/getFillFormList")
    public Map getFillFormList(@AuthenticationPrincipal TOperator operUser) throws Exception {
        Map map = new HashMap();
        try {
            String opertype = operUser.getOpertype();
            //名单状态
            List<TDictionaryId> syncDicts = systemService.findTDictionaryByType(3);
            map.put("syncDicts", syncDicts);
            //厂商id
            List<TKey> allFactoryId = webInterfaceService.getAllKeys();
            map.put("allFactoryId", allFactoryId);
            //操作标记
            List<TDictionaryId> operDicts = new ArrayList<TDictionaryId>();
            operDicts.addAll(systemService.findByType(2, "A"));
            operDicts.addAll(systemService.findByType(2, "D"));
            operDicts.addAll(systemService.findByType(2, "C"));
            map.put("operDicts", operDicts);

            List<TRegion> regions = null;
            List<TBuilding> buildings = null;
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))) {
                regions = systemService.getAllRegions();
                buildings = ncService.getAllBuilding();
                map.put("regions", regions);
                map.put("buildings", buildings);
            }else if (!StringUtil.isEmpty(operUser.getRegionid())){
                regions = systemService.getRegionListById(operUser.getRegionid());
                map.put("regions", regions);
                buildings = systemService.getBuildingByRegionId(operUser.getRegionid());
                map.put("buildings", buildings);
            }

        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 查询设备名单
     * @param request
     * @param factoryId
     * @param doorName
     * @param custName
     * @param stuempNo
     * @param syncStatus
     * @param operFlag
     * @param buildingid
     * @param regionid
     * @param allocatStartDate
     * @param allocatEndDate
     * @param pageNo
     * @param pageSize
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/getAllCardList")
    public Map getAllCardList(HttpServletRequest request,
                                 @RequestParam(value = "factoryId", required = false, defaultValue = "all") String factoryId,
                                 @RequestParam(value = "doorName", required = false, defaultValue = "") String doorName,
                                 @RequestParam(value = "custName", required = false, defaultValue = "") String custName,
                                 @RequestParam(value = "stuempNo", required = false, defaultValue = "") String stuempNo,
                                 @RequestParam(value = "syncStatus", required = false, defaultValue = "all") String syncStatus,
                                 @RequestParam(value = "operFlag", required = false, defaultValue = "all") String operFlag,
                                 @RequestParam(value = "buildingid", required = false, defaultValue = "") String buildingid,
                                 @RequestParam(value = "regionid",required = false,defaultValue = "") String regionid,
                                 @RequestParam(value = "allocatStartDate", required = false, defaultValue = "") String allocatStartDate,
                                 @RequestParam(value = "allocatEndDate", required = false, defaultValue = "") String allocatEndDate,
                                 @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                                 @RequestParam(value = "pageSize", required = false, defaultValue = "15") int pageSize,
                                 @AuthenticationPrincipal TOperator operUser) {

        Map map = new HashMap();
        try {
            String opertype = operUser.getOpertype();
            boolean flag = true;
            Pagination pResult  = new Pagination();
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                pResult = webInterfaceService.getSystemCardListFrSearch(factoryId, allocatStartDate, allocatEndDate, doorName, custName, stuempNo, syncStatus, operFlag, buildingid, regionid, pageNo, pageSize);
            }else if (!StringUtil.isEmpty(operUser.getRegionid())){
                pResult = webInterfaceService.getOperatorCardListFrSearch(factoryId, allocatStartDate, allocatEndDate, doorName, custName, stuempNo, syncStatus, operFlag, buildingid, regionid, pageNo, pageSize,operUser.getRegionid());
            }
            map.put("PageResult", pResult);
            map.put("index", flag);
            map.put("result", "查询设备名单成功！");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "查询设备名单失败！");
            logger.error("查询设备名单失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 注解方式导出设备名单Excel
     * @param modelMap
     * @param request
     * @param response
     * @param factoryId
     * @param doorName
     * @param custName
     * @param stuempNo
     * @param syncStatus
     * @param operFlag
     * @param buildingid
     * @param regionid
     * @param allocatStartDate
     * @param allocatEndDate
     * @param operUser
     */
    @RequestMapping(value = "/exportExcel", method = RequestMethod.GET)
    public void download(ModelMap modelMap, HttpServletRequest request, HttpServletResponse response,
                         @RequestParam(value = "factoryId", required = false, defaultValue = "all") String factoryId,
                         @RequestParam(value = "doorName", required = false, defaultValue = "") String doorName,
                         @RequestParam(value = "custName", required = false, defaultValue = "") String custName,
                         @RequestParam(value = "stuempNo", required = false, defaultValue = "") String stuempNo,
                         @RequestParam(value = "syncStatus", required = false, defaultValue = "all") String syncStatus,
                         @RequestParam(value = "operFlag", required = false, defaultValue = "all") String operFlag,
                         @RequestParam(value = "buildingid", required = false, defaultValue = "") String buildingid,
                         @RequestParam(value = "regionid",required = false,defaultValue = "") String regionid,
                         @RequestParam(value = "allocatStartDate", required = false, defaultValue = "") String allocatStartDate,
                         @RequestParam(value = "allocatEndDate", required = false, defaultValue = "") String allocatEndDate,
                         @AuthenticationPrincipal TOperator operUser) {
        String opertype = operUser.getOpertype();
        /**
         * 1.查询值
         */
        List<TDoorcardlstInfo> cardList = null;
        if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))) {
            cardList=webInterfaceService.getSystemCardListMap(factoryId, allocatStartDate, allocatEndDate,
                    doorName, custName, stuempNo, syncStatus, operFlag, buildingid, regionid);
        }else if (!StringUtil.isEmpty(operUser.getRegionid())){
            cardList = webInterfaceService.getOperatorCardListMap(factoryId, allocatStartDate, allocatEndDate,
                    doorName, custName, stuempNo, syncStatus, operFlag, buildingid, regionid,operUser.getRegionid());
        }

        /**
         * 2.设置表格属性: title:标题  sheetName:工作簿名 type:表格类型
         */
        ExportParams params = new ExportParams("设备名单列表", "设备名单", ExcelType.XSSF);

        modelMap.put(NormalExcelConstants.DATA_LIST, cardList);//设置值
        modelMap.put(NormalExcelConstants.PARAMS, params);//设置属性
        modelMap.put(NormalExcelConstants.CLASS, TDoorcardlstInfo.class);
        modelMap.put(NormalExcelConstants.FILE_NAME, "下发设备名单");
        PoiBaseView.render(modelMap, request, response, NormalExcelConstants.EASYPOI_EXCEL_VIEW);

    }

    /**
     * 重新下发名单
     * @param request
     * @param tDoorcardlstInfos
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/reSaveDoorCardList", method = {RequestMethod.POST})
    public Map reSaveDoorCardList(HttpServletRequest request,
                                     @RequestBody TDoorcardlstInfo[] tDoorcardlstInfos){
        Map map = new HashMap();
        String msg = "";
        try {
            List<Long> listIds = new ArrayList<>();
            for (TDoorcardlstInfo tDoorcardlstInfo:tDoorcardlstInfos){
                listIds.add(Long.valueOf(tDoorcardlstInfo.getListid()));
            }
            webInterfaceService.updateDoorcardlstToNoWithIds(listIds);
            RedisUtil.incr("zcard_max_version");
            map.put("result","重新下发设备名单成功！");
        }catch (Exception e){
            e.printStackTrace();
            map.put("result","重新下发设备名单失败！");
            msg = "重新下发设备名单异常";
            logger.error("重定向出错："+e.getMessage());
        }
        map.put("msg",msg);
        return map;
    }
}
