package com.supwisdom.dlpay.mainservice.dao.impl;

import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.bean.TDoorcardlstInfo;
import com.supwisdom.dlpay.mainservice.dao.CardListDao;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.util.RedisUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Repository
public class CardListDaoImpl implements CardListDao {

    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getSystemCardListFrSearch(String factoryId, String allocatStartDate, String allocatEndDate, String doorName, String custName, String stuempNo, String syncStatus, String operFlag, String buildingid,String regionid, int pageNo, int pageSize) {
        try {

            String queryString = "select a.listid, a.factoryId,d.doorName,a.custName,g.operName,a.stuempNo," +
                    "a.syncStatus,a.operFlag operFlagIndex,a.updatetime allocatTime,a.syncTime,a.closedate," +
                    "b.updatetime feedbackTime,b.retmsg,a.reason ,a.buildingName,f.regionName" +
                    " from t_doorcardlst a " +
                    " left join t_rtnresult b on a.listid=b.listid " +
                    " left join tb_region f on a.regionid=f.regionid " +
                    " left join t_doordev d on a.deviceid=d.doorid" +
                    " left join tb_operator g on a.operid=g.operid" +
                    " where 1>0 " ;
            if (!"".equals(allocatStartDate)) {
                queryString += " and a.updatetime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.updatetime<=:allocatEndDate ";
            }
            if (!("all").equals(syncStatus)) {
                queryString += " and a.syncstatus =:syncStatus";
            }
            if (!("all").equals(factoryId)) {
                queryString += " and a.factoryid =:factoryId";
            }
            if (!("").equals(doorName)) {
                queryString += " and d.doorname like :doorName";
            }
            if (!("all").equals(operFlag)) {
                queryString += " and a.operFlag =:operFlag";
            }
            if (!("").equals(buildingid)) {
                queryString += " and a.buildingid = :buildingid ";
            }
            if (!regionid.equals("")){
                queryString += "and a.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  )";
            }
            if (!("").equals(custName)) {
                queryString += " and a.custname like :custName";
            }
            if (!("").equals(stuempNo)) {
                queryString += " and a.stuempno like :stuempNo";
            }
            queryString += " ORDER by a.listid DESC";

            Query query = entityManager.createNativeQuery(queryString, TDoorcardlstInfo.class);

            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncStatus)) {
                query.setParameter("syncStatus", syncStatus);
            }
            if (!("all").equals(factoryId)) {
                query.setParameter("factoryId", factoryId);
            }
            if (!("").equals(doorName)) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!("all").equals(operFlag)) {
                query.setParameter("operFlag", operFlag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(regionid)){
                query.setParameter("regionid", regionid);
            }
            if (!("").equals(custName)) {
                query.setParameter("custName", "%" + custName + "%");
            }
            if (!("").equals(stuempNo)) {
                query.setParameter("stuempNo", stuempNo);
            }

            pageNo = pageNo <= 0 ? 1 : pageNo;
            query.setFirstResult((pageNo - 1) * pageSize);
            query.setMaxResults(pageSize);
            Pagination page = new Pagination();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);

            int totalCount = getSystemCardListCount(factoryId, allocatStartDate, allocatEndDate, doorName, custName, stuempNo, syncStatus, operFlag, buildingid, regionid);
            page.setTotalCount(totalCount);

            List<TDoorcardlstInfo> tDoorcardlstInfos = query.getResultList();
            SimpleDateFormat _ymdhms = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (TDoorcardlstInfo grp : tDoorcardlstInfos) {
                List<String> factory = RedisUtil.lrange("dict_4", 0, -1);
                List<String> operflag = RedisUtil.lrange("dict_2", 0, -1);
                List<String> sync = RedisUtil.lrange("dict_3", 0, -1);
                if(operflag!= null && operflag.size()>0){
                    String operFlagIndex = grp.getOperFlagIndex();
                    for (String s : operflag) {
                        String[] split = s.split("_");
                        if (operFlagIndex.equals(split[0])){
                            grp.setOperFlag(split[1]);
                            break;
                        }
                    }
                }
                if(sync!= null && sync.size()>0){
                    String syncStatus1 = grp.getSyncStatus();
                    for (String s : sync) {
                        String[] split = s.split("_");
                        if (syncStatus1.equals(split[0])){
                            grp.setSyncStatus(split[1]);
                            break;
                        }else {
                            grp.setSyncStatus("");
                        }
                    }
                }
                if(factory != null && factory.size()>0){
                    String factoryId1 = grp.getFactoryId();
                    for (String s : factory) {
                        String[] split = s.split("_");
                        if (factoryId1.equals(split[0])){
                            grp.setFactoryName(split[1]);
                            break;
                        }else {
                            grp.setFactoryName("");
                        }
                    }
                }else {
                    queryString = "select a.id.dictcaption from TDictionary a where a.id.dicttype=:dicttype and a.id.dictval=:dictval";
                    query = entityManager.createQuery(queryString);
                    query.setParameter("dicttype", 4);
                    query.setParameter("dictval", grp.getFactoryId());
                    if(null != query.getSingleResult()){
                        grp.setFactoryName(query.getSingleResult().toString());
                    }else {
                        grp.setFactoryName("");
                    }

                    query.setParameter("dicttype", 3);
                    query.setParameter("dictval", grp.getSyncStatus());
                    if(null != query.getSingleResult()) {
                        grp.setSyncStatus(query.getSingleResult().toString());
                    }else {
                        grp.setSyncStatus("");
                    }
                    query.setParameter("dicttype", 2);
                    if (grp.getOperFlagIndex() != null) {
                        query.setParameter("dictval", grp.getOperFlagIndex());
                        grp.setOperFlag(query.getSingleResult().toString());
                    }
                }


                String time = grp.getAllocatTime();
                Date date;
                String hms = "000000";
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setAllocatTime(ymdhms.format(date));
                    } else {

                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time + "");
                        grp.setAllocatTime(ymdhms.format(date));
                    }

                }

                time = grp.getSyncTime();
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setSyncTime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setSyncTime(ymdhms.format(date));
                    }

                }

                time = grp.getFeedbackTime();
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setFeedbackTime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setFeedbackTime(ymdhms.format(date));
                    }
                }

            }

            page.setList(tDoorcardlstInfos);
            return page;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    private int getSystemCardListCount(String factoryId, String allocatStartDate, String allocatEndDate, String doorName, String custName, String stuempNo, String syncStatus, String operFlag, String buildingid,String regionid){
        try {
            String queryString = "select count(*) from T_Doordev d,T_Doorcardlst a" +
                    " left join tb_region f on a.regionid=f.regionid " +
                    "where  a.factoryid=d.factoryid " +
                    " and a.deviceid=d.doorid ";

            if (!"".equals(allocatStartDate)) {
                queryString += " and a.updatetime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.updatetime<=:allocatEndDate ";
            }
            if (!("all").equals(syncStatus)) {
                queryString += " and a.syncstatus =:syncStatus";
            }
            if (!("all").equals(factoryId)) {
                queryString += " and a.id.factoryid =:factoryId";
            }
            if (!("all").equals(operFlag)) {
                queryString += " and a.operflag =:operFlag";
            }
            if (!("").equals(buildingid)) {
                queryString += " and a.buildingid = :buildingid ";
            }
            if (!regionid.equals("")){
                queryString += "and a.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  )";
            }
            if (!("").equals(doorName)) {
                queryString += " and d.doorname like :doorName";
            }
            if (!("").equals(custName)) {
                queryString += " and a.custname like :custName";
            }
            if (!("").equals(stuempNo)) {
                queryString += " and a.stuempno like :stuempNo";
            }
            Query query = entityManager.createNativeQuery(queryString);
            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }

            if (!("all").equals(syncStatus)) {
                query.setParameter("syncStatus", syncStatus);
            }
            if (!("all").equals(factoryId)) {
                query.setParameter("factoryId", factoryId);
            }
            if (!("all").equals(operFlag)) {
                query.setParameter("operFlag", operFlag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(regionid)){
                query.setParameter("regionid", regionid);
            }
            if (!("").equals(doorName)) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!("").equals(custName)) {
                query.setParameter("custName", "%" + custName + "%");
            }
            if (!("").equals(stuempNo)) {
                query.setParameter("stuempNo", stuempNo);
            }
            int cnt = 0;
            List list = query.getResultList();
            if (list!=null && list.size()>0){
                Object o = list.get(0);
                cnt = Integer.parseInt(o.toString());
            }
            return cnt;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Transactional
    @Override
    public Pagination getOperatorCardListFrSearch(String factoryId, String allocatStartDate, String allocatEndDate, String doorName, String custName, String stuempNo, String syncStatus, String operFlag, String buildingid, String regionid, int pageNo, int pageSize, String operRegionid) {
        try {

            String queryString = "select a.listid, a.factoryId,d.doorName,a.custName,g.operName,a.stuempNo," +
                    "a.syncStatus,a.operFlag operFlagIndex,a.updatetime allocatTime,a.syncTime,a.closedate," +
                    "b.updatetime feedbackTime,b.retmsg,a.reason ,a.buildingName,f.regionName" +
                    " from t_doorcardlst a left join t_rtnresult b on a.listid=b.listid " +
                    " left join tb_region f on a.regionid=f.regionid " +
                    " left join t_doordev d on a.deviceid=d.doorid" +
                    " left join tb_operator g on a.operid=g.operid" +
                    " where 1>0 " ;
            if (!"".equals(allocatStartDate)) {
                queryString += " and a.updatetime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.updatetime<=:allocatEndDate ";
            }
            if (!("all").equals(syncStatus)) {
                queryString += " and a.syncstatus =:syncStatus";
            }
            if (!("all").equals(factoryId)) {
                queryString += " and a.factoryid =:factoryId";
            }
            if (!("").equals(doorName)) {
                queryString += " and d.doorname like :doorName";
            }
            if (!("all").equals(operFlag)) {
                queryString += " and a.operFlag =:operFlag";
            }
            if (!("").equals(buildingid)) {
                queryString += " and a.buildingid = :buildingid ";
            }

            if (!regionid.equals("")){
                queryString += "and a.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  where tmp.regionid=:regionid)";
            }else {
                queryString += "and a.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  )";
            }
            if (!("").equals(custName)) {
                queryString += " and a.custname like :custName";
            }
            if (!("").equals(stuempNo)) {
                queryString += " and a.stuempno like :stuempNo";
            }
            queryString += " ORDER by a.listid DESC";

            Query query = entityManager.createNativeQuery(queryString, TDoorcardlstInfo.class);

            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncStatus)) {
                query.setParameter("syncStatus", syncStatus);
            }
            if (!("all").equals(factoryId)) {
                query.setParameter("factoryId", factoryId);
            }
            if (!("").equals(doorName)) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!("all").equals(operFlag)) {
                query.setParameter("operFlag", operFlag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            query.setParameter("operRegionid", operRegionid);
            if (!("").equals(regionid)){
                query.setParameter("regionid", regionid);
            }
            if (!("").equals(custName)) {
                query.setParameter("custName", "%" + custName + "%");
            }
            if (!("").equals(stuempNo)) {
                query.setParameter("stuempNo", stuempNo);
            }

            pageNo = pageNo <= 0 ? 1 : pageNo;
            query.setFirstResult((pageNo - 1) * pageSize);
            query.setMaxResults(pageSize);
            Pagination page = new Pagination();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);

            int totalCount = getOperatorCardListCount(factoryId, allocatStartDate, allocatEndDate, doorName, custName, stuempNo, syncStatus, operFlag, buildingid, regionid,operRegionid);
            page.setTotalCount(totalCount);

            List<TDoorcardlstInfo> tDoorcardlstInfos = query.getResultList();
            SimpleDateFormat _ymdhms = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (TDoorcardlstInfo grp : tDoorcardlstInfos) {
                List<String> factory = RedisUtil.lrange("dict_4", 0, -1);
                List<String> operflag = RedisUtil.lrange("dict_2", 0, -1);
                List<String> sync = RedisUtil.lrange("dict_3", 0, -1);
                if(operflag!= null && operflag.size()>0){
                    String operFlagIndex = grp.getOperFlagIndex();
                    for (String s : operflag) {
                        String[] split = s.split("_");
                        if (operFlagIndex.equals(split[0])){
                            grp.setOperFlag(split[1]);
                            break;
                        }
                    }
                }
                if(sync!= null && sync.size()>0){
                    String syncStatus1 = grp.getSyncStatus();
                    for (String s : sync) {
                        String[] split = s.split("_");
                        if (syncStatus1.equals(split[0])){
                            grp.setSyncStatus(split[1]);
                            break;
                        }else {
                            grp.setSyncStatus("");
                        }
                    }
                }
                if(factory != null && factory.size()>0){
                    String factoryId1 = grp.getFactoryId();
                    for (String s : factory) {
                        String[] split = s.split("_");
                        if (factoryId1.equals(split[0])){
                            grp.setFactoryName(split[1]);
                            break;
                        }else {
                            grp.setFactoryName("");
                        }
                    }
                }else {
                    queryString = "select a.id.dictcaption from TDictionary a where a.id.dicttype=:dicttype and a.id.dictval=:dictval";
                    query = entityManager.createQuery(queryString);
                    query.setParameter("dicttype", 4);
                    query.setParameter("dictval", grp.getFactoryId());
                    if(null != query.getSingleResult()){
                        grp.setFactoryName(query.getSingleResult().toString());
                    }else {
                        grp.setFactoryName("");
                    }

                    query.setParameter("dicttype", 3);
                    query.setParameter("dictval", grp.getSyncStatus());
                    if(null != query.getSingleResult()) {
                        grp.setSyncStatus(query.getSingleResult().toString());
                    }else {
                        grp.setSyncStatus("");
                    }
                    query.setParameter("dicttype", 2);
                    if (grp.getOperFlagIndex() != null) {
                        query.setParameter("dictval", grp.getOperFlagIndex());
                        grp.setOperFlag(query.getSingleResult().toString());
                    }
                }


                String time = grp.getAllocatTime();
                Date date;
                String hms = "000000";
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setAllocatTime(ymdhms.format(date));
                    } else {

                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time + "");
                        grp.setAllocatTime(ymdhms.format(date));
                    }

                }

                time = grp.getSyncTime();
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setSyncTime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setSyncTime(ymdhms.format(date));
                    }

                }

                time = grp.getFeedbackTime();
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setFeedbackTime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setFeedbackTime(ymdhms.format(date));
                    }
                }

            }

            page.setList(tDoorcardlstInfos);
            return page;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    private int getOperatorCardListCount(String factoryId, String allocatStartDate, String allocatEndDate, String doorName, String custName, String stuempNo, String syncStatus, String operFlag, String buildingid,String regionid,String operRegionid){
        try {
            String queryString = "select count(*) from T_Doordev d,T_Doorcardlst a" +
                    " left join tb_region f on a.regionid=f.regionid " +
                    "where  a.factoryid=d.factoryid " +
                    " and a.deviceid=d.doorid ";

            if (!"".equals(allocatStartDate)) {
                queryString += " and a.updatetime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.updatetime<=:allocatEndDate ";
            }
            if (!("all").equals(syncStatus)) {
                queryString += " and a.syncstatus =:syncStatus";
            }
            if (!("all").equals(factoryId)) {
                queryString += " and a.id.factoryid =:factoryId";
            }
            if (!("all").equals(operFlag)) {
                queryString += " and a.operflag =:operFlag";
            }
            if (!("").equals(buildingid)) {
                queryString += " and a.buildingid = :buildingid ";
            }
            if (!regionid.equals("")){
                queryString += "and a.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  where tmp.regionid=:regionid)";
            }else {
                queryString += "and a.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  )";
            }
            if (!("").equals(doorName)) {
                queryString += " and d.doorname like :doorName";
            }
            if (!("").equals(custName)) {
                queryString += " and a.custname like :custName";
            }
            if (!("").equals(stuempNo)) {
                queryString += " and a.stuempno like :stuempNo";
            }
            Query query = entityManager.createNativeQuery(queryString);
            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }

            if (!("all").equals(syncStatus)) {
                query.setParameter("syncStatus", syncStatus);
            }
            if (!("all").equals(factoryId)) {
                query.setParameter("factoryId", factoryId);
            }
            if (!("all").equals(operFlag)) {
                query.setParameter("operFlag", operFlag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            query.setParameter("operRegionid", operRegionid);
            if (!("").equals(regionid)){
                query.setParameter("regionid", regionid);
            }
            if (!("").equals(doorName)) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!("").equals(custName)) {
                query.setParameter("custName", "%" + custName + "%");
            }
            if (!("").equals(stuempNo)) {
                query.setParameter("stuempNo", stuempNo);
            }
            int cnt = 0;
            List list = query.getResultList();
            if (list!=null && list.size()>0){
                Object o = list.get(0);
                cnt = Integer.parseInt(o.toString());
            }
            return cnt;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }


    @Transactional
    @Override
    public List<TDoorcardlstInfo> getSystemCardListMap(String factoryId, String allocatStartDate, String allocatEndDate, String doorName, String custName, String stuempNo, String syncStatus, String operFlag, String buildingid,String regionid) {
        try {
            String queryString = "select a.listid, a.factoryId,d.doorName,a.custName,g.operName,a.stuempNo," +
                    "a.syncStatus,a.operFlag operFlagIndex,a.updatetime allocatTime,a.syncTime,a.closedate," +
                    "b.updatetime feedbackTime,b.retmsg,a.reason ,a.buildingName,f.regionName" +
                    " from t_doorcardlst a left join t_rtnresult b on a.listid=b.listid " +
                    " left join tb_region f on a.regionid=f.regionid " +
                    " left join t_doordev d on a.deviceid=d.doorid" +
                    " left join tb_operator g on a.operid=g.operid" +
                    " where 1>0 ";
            if (!"".equals(allocatStartDate)) {
                queryString += " and a.updatetime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.updatetime<=:allocatEndDate ";
            }
            if (!("all").equals(syncStatus)) {
                queryString += " and a.syncstatus =:syncStatus";
            }
            if (!("all").equals(factoryId)) {
                queryString += " and a.factoryid =:factoryId";
            }
            if (!("").equals(doorName)) {
                queryString += " and d.doorname like :doorName";
            }
            if (!("all").equals(operFlag)) {
                queryString += " and a.operFlag =:operFlag";
            }
            if (!("").equals(buildingid)) {
                queryString += " and a.buildingid = :buildingid";
            }
            if (!regionid.equals("")){
                queryString += "and a.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  )";
            }
            if (!("").equals(custName)) {
                queryString += " and a.custname like :custName";
            }
            if (!("").equals(stuempNo)) {
                queryString += " and a.stuempno like :stuempNo";
            }
            queryString += " order by a.listid DESC";

            Query query = entityManager.createNativeQuery(queryString, TDoorcardlstInfo.class);
            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncStatus)) {
                query.setParameter("syncStatus", syncStatus);
            }
            if (!("all").equals(factoryId)) {
                query.setParameter("factoryId", factoryId);
            }
            if (!("").equals(doorName)) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!("all").equals(operFlag)) {
                query.setParameter("operFlag", operFlag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(regionid)){
                query.setParameter("regionid",regionid);
            }
            if (!("").equals(custName)) {
                query.setParameter("custName", "%" + custName + "%");
            }
            if (!("").equals(stuempNo)) {
                query.setParameter("stuempNo", "%" + stuempNo + "%");
            }

            List<TDoorcardlstInfo> tDoorcardlstInfos = query.getResultList();
            SimpleDateFormat _ymdhms = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (TDoorcardlstInfo grp : tDoorcardlstInfos) {
                List<String> factory = RedisUtil.lrange("dict_4", 0, -1);
                List<String> operflag = RedisUtil.lrange("dict_2", 0, -1);
                List<String> sync = RedisUtil.lrange("dict_3", 0, -1);
                if(operflag!= null && operflag.size()>0){
                    String operFlagIndex = grp.getOperFlagIndex();
                    for (String s : operflag) {
                        String[] split = s.split("_");
                        if (operFlagIndex.equals(split[0])){
                            grp.setOperFlag(split[1]);
                            break;
                        }
                    }
                }
                if(sync!= null && sync.size()>0){
                    String syncStatus1 = grp.getSyncStatus();
                    for (String s : sync) {
                        String[] split = s.split("_");
                        if (syncStatus1.equals(split[0])){
                            grp.setSyncStatus(split[1]);
                            break;
                        }else {
                            grp.setSyncStatus("");
                        }
                    }
                }
                if(factory != null && factory.size()>0){
                    String factoryId1 = grp.getFactoryId();
                    for (String s : factory) {
                        String[] split = s.split("_");
                        if (factoryId1.equals(split[0])){
                            grp.setFactoryName(split[1]);
                            break;
                        }else {
                            grp.setFactoryName("");
                        }
                    }
                }else {
                    queryString = "select a.id.dictcaption from TDictionary a where a.id.dicttype=:dicttype and a.id.dictval=:dictval";
                    query = entityManager.createQuery(queryString);
                    query.setParameter("dicttype", 4);
                    query.setParameter("dictval", grp.getFactoryId());
                    if(null != query.getSingleResult()){
                        grp.setFactoryName(query.getSingleResult().toString());
                    }else {
                        grp.setFactoryName("");
                    }

                    query.setParameter("dicttype", 3);
                    query.setParameter("dictval", grp.getSyncStatus());
                    if(null != query.getSingleResult()) {
                        grp.setSyncStatus(query.getSingleResult().toString());
                    }else {
                        grp.setSyncStatus("");
                    }
                    query.setParameter("dicttype", 2);
                    if (grp.getOperFlagIndex() != null) {
                        query.setParameter("dictval", grp.getOperFlagIndex());
                        grp.setOperFlag(query.getSingleResult().toString());
                    }
                }

                String time = grp.getAllocatTime();
                Date date;
                String hms = "000000";
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setAllocatTime(ymdhms.format(date));
                    } else {

                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time + "");
                        grp.setAllocatTime(ymdhms.format(date));
                    }

                }

                time = grp.getSyncTime();
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setSyncTime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setSyncTime(ymdhms.format(date));
                    }

                }

                time = grp.getFeedbackTime();
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setFeedbackTime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setFeedbackTime(ymdhms.format(date));
                    }
                }
            }
            return tDoorcardlstInfos;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional
    @Override
    public List<TDoorcardlstInfo> getOperatorCardListMap(String factoryId, String allocatStartDate, String allocatEndDate, String doorName, String custName, String stuempNo, String syncStatus, String operFlag, String buildingid, String regionid, String operRegionid) {
        try {
            String queryString = "select a.listid, a.factoryId,d.doorName,a.custName,g.operName,a.stuempNo," +
                    "a.syncStatus,a.operFlag operFlagIndex,a.updatetime allocatTime,a.syncTime,a.closedate," +
                    "b.updatetime feedbackTime,b.retmsg,a.reason ,a.buildingName,f.regionName" +
                    " from t_doorcardlst a left join t_rtnresult b on a.listid=b.listid " +
                    " left join tb_region f on a.regionid=f.regionid " +
                    " left join t_doordev d on a.deviceid=d.doorid" +
                    " left join tb_operator g on a.operid=g.operid" +
                    " where 1>0 " ;
            if (!"".equals(allocatStartDate)) {
                queryString += " and a.updatetime>=:allocatStartDate ";
            }
            if (!"".equals(allocatEndDate)) {
                queryString += " and a.updatetime<=:allocatEndDate ";
            }
            if (!("all").equals(syncStatus)) {
                queryString += " and a.syncstatus =:syncStatus";
            }
            if (!("all").equals(factoryId)) {
                queryString += " and a.factoryid =:factoryId";
            }
            if (!("").equals(doorName)) {
                queryString += " and d.doorname like :doorName";
            }
            if (!("all").equals(operFlag)) {
                queryString += " and a.operFlag =:operFlag";
            }
            if (!("").equals(buildingid)) {
                queryString += " and a.buildingid = :buildingid";
            }
            if (!regionid.equals("")){
                queryString += "and a.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  where tmp.regionid=:regionid)";
            }else {
                queryString += "and a.regionid in  "
                    +"("
                    + "with recursive tmp as  "
                    + "("
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :operRegionid  "
                    + "union all  "
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                    + ") select regionid from tmp )";

            }
            if (!("").equals(custName)) {
                queryString += " and a.custname like :custName";
            }
            if (!("").equals(stuempNo)) {
                queryString += " and a.stuempno like :stuempNo";
            }
            queryString += " order by a.listid DESC";

            Query query = entityManager.createNativeQuery(queryString, TDoorcardlstInfo.class);
            if (!"".equals(allocatStartDate)) {
                query.setParameter("allocatStartDate", allocatStartDate + "000000");
            }
            if (!"".equals(allocatEndDate)) {
                query.setParameter("allocatEndDate", allocatEndDate + "235959");
            }


            if (!("all").equals(syncStatus)) {
                query.setParameter("syncStatus", syncStatus);
            }
            if (!("all").equals(factoryId)) {
                query.setParameter("factoryId", factoryId);
            }
            if (!("").equals(doorName)) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!("all").equals(operFlag)) {
                query.setParameter("operFlag", operFlag);
            }
            if (!("").equals(buildingid)) {
                query.setParameter("buildingid", buildingid);
            }
            if (!("").equals(regionid)){
                query.setParameter("regionid",regionid);
            }
            if (!("").equals(custName)) {
                query.setParameter("custName", "%" + custName + "%");
            }
            if (!("").equals(stuempNo)) {
                query.setParameter("stuempNo", "%" + stuempNo + "%");
            }

            List<TDoorcardlstInfo> tDoorcardlstInfos = query.getResultList();
            SimpleDateFormat _ymdhms = new SimpleDateFormat("yyyyMMddHHmmss");
            SimpleDateFormat ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (TDoorcardlstInfo grp : tDoorcardlstInfos) {
                List<String> factory = RedisUtil.lrange("dict_4", 0, -1);
                List<String> operflag = RedisUtil.lrange("dict_2", 0, -1);
                List<String> sync = RedisUtil.lrange("dict_3", 0, -1);
                if(operflag!= null && operflag.size()>0){
                    String operFlagIndex = grp.getOperFlagIndex();
                    for (String s : operflag) {
                        String[] split = s.split("_");
                        if (operFlagIndex.equals(split[0])){
                            grp.setOperFlag(split[1]);
                            break;
                        }
                    }
                }
                if(sync!= null && sync.size()>0){
                    String syncStatus1 = grp.getSyncStatus();
                    for (String s : sync) {
                        String[] split = s.split("_");
                        if (syncStatus1.equals(split[0])){
                            grp.setSyncStatus(split[1]);
                            break;
                        }else {
                            grp.setSyncStatus("");
                        }
                    }
                }
                if(factory != null && factory.size()>0){
                    String factoryId1 = grp.getFactoryId();
                    for (String s : factory) {
                        String[] split = s.split("_");
                        if (factoryId1.equals(split[0])){
                            grp.setFactoryName(split[1]);
                            break;
                        }else {
                            grp.setFactoryName("");
                        }
                    }
                }else {
                    queryString = "select a.id.dictcaption from TDictionary a where a.id.dicttype=:dicttype and a.id.dictval=:dictval";
                    query = entityManager.createQuery(queryString);
                    query.setParameter("dicttype", 4);
                    query.setParameter("dictval", grp.getFactoryId());
                    if(null != query.getSingleResult()){
                        grp.setFactoryName(query.getSingleResult().toString());
                    }else {
                        grp.setFactoryName("");
                    }

                    query.setParameter("dicttype", 3);
                    query.setParameter("dictval", grp.getSyncStatus());
                    if(null != query.getSingleResult()) {
                        grp.setSyncStatus(query.getSingleResult().toString());
                    }else {
                        grp.setSyncStatus("");
                    }
                    query.setParameter("dicttype", 2);
                    if (grp.getOperFlagIndex() != null) {
                        query.setParameter("dictval", grp.getOperFlagIndex());
                        grp.setOperFlag(query.getSingleResult().toString());
                    }
                }

                String time = grp.getAllocatTime();
                Date date;
                String hms = "000000";
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setAllocatTime(ymdhms.format(date));
                    } else {

                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time + "");
                        grp.setAllocatTime(ymdhms.format(date));
                    }

                }

                time = grp.getSyncTime();
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setSyncTime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setSyncTime(ymdhms.format(date));
                    }

                }

                time = grp.getFeedbackTime();
                if (time != null) {
                    if (time.length() == 14) {
                        date = _ymdhms.parse(time);
                        grp.setFeedbackTime(ymdhms.format(date));
                    } else {
                        time += hms.substring(0, 14 - time.length());
                        date = _ymdhms.parse(time);
                        grp.setFeedbackTime(ymdhms.format(date));
                    }
                }
            }
            return tDoorcardlstInfos;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional
    @Override
    public void updateDoorcardlstToNoWithIds(List<Long> listIds) {
        String sql = "update T_DOORCARDLST set version = version+1,syncstatus='0',SYNCTIME='', UPDATETIME=to_char(current_timestamp, 'YYYYMMDDHH24MISS') where listid in " + StringUtil.intOrLikeIntListTransToStr(listIds);
        Query query = entityManager.createNativeQuery(sql);
        query.executeUpdate();
    }
}
