package com.supwisdom.dlpay.mainservice.dao.impl;

import com.supwisdom.dlpay.mainservice.bean.TDoordtlInfo;
import com.supwisdom.dlpay.mainservice.dao.DoordtlDao;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.List;

@Repository
public class DoordtlDaoImpl implements DoordtlDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public List<TDoordtlInfo> findSystemExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno, String custname, String buildingid, String regionid, String doorName, String factoryId, String streamstatus) {
        try {
            String queryString = "select a.dtldesc , c.factoryname,d.doorname,b.stuempno,b.custname,tb.buildingname,tr.regionname," +
                    " to_char(to_date(a.transdate||a.transtime ,'yyyymmddhh24miss'),'yyyy-mm-dd hh24:mi:ss') as transdate, "
                    + "case when a.status='0' then '失败' else '成功' end status,to_char(to_date(  a.coldate||a.coltime,'yyyymmddhh24miss'),'yyyy-mm-dd hh24:mi:ss') as coldate  " + "from  "
                    + "t_doordtl a "
                    + "left join t_customer b on a.custid=b.custid " + "left join "
                    + "t_building tb on b.buildingid=tb.buildingid " + "left join  "
                    + "tb_region tr on a.regionid = tr.regionid "+ "left join  "
                    + "t_doordev d  on a.doorid = d.doorid, " + "t_keys c " + "where a.factoryid=c.factoryid  ";
            if (!startTranDate.equals("")) {
                queryString += "  and a.transdate>=:startTranDate and a.transdate<=:endTranDate ";
            }
            if (!startTranTime.equals("")) {
                queryString += "  and a.transtime>=:startTranTime and a.transtime<=:endTranTime ";
            }
            if (!stuempno.equals("")) {
                queryString += " and b.stuempno like :stuempno ";
            }
            if (!custname.equals("")) {
                queryString += " and b.custname like :custname ";
            }
            if (!buildingid.equals("")) {
                queryString += " and tb.buildingid = :buildingid ";
            }
            if (!regionid.equals("")){
                queryString += "and tr.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid =:regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  )";
            }
            if (!doorName.equals("")) {
                queryString += " and d.doorName like :doorName ";
            }
            if (!factoryId.equals("all")) {
                queryString += " and c.factoryId =:factoryId ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            Query query = entityManager.createNativeQuery(queryString, TDoordtlInfo.class);
            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!startTranTime.equals("")) {
                query.setParameter("startTranTime", startTranTime);
                query.setParameter("endTranTime", endTranTime);
            }
            if (!stuempno.equals("")) {
                query.setParameter("stuempno", "%" + stuempno + "%");
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
            }
            if (!regionid.equals("")){
                query.setParameter("regionid", regionid);
            }
            if (!doorName.equals("")) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!factoryId.equals("all")) {
                query.setParameter("factoryId", factoryId);
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            List<TDoordtlInfo> list = query.getResultList();
            return list;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional
    @Override
    public List<TDoordtlInfo> findOperatorExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno, String custname, String buildingid, String regionid, String doorName, String factoryId, String streamstatus, String operRegionid) {
        try {
            String queryString = "select a.dtldesc , c.factoryname,d.doorname,b.stuempno,b.custname,tb.buildingname,tr.regionname," +
                    " to_char(to_date(a.transdate||a.transtime ,'yyyymmddhh24miss'),'yyyy-mm-dd hh24:mi:ss') as transdate, "
                    + "case when a.status='0' then '失败' else '成功' end status,to_char(to_date(  a.coldate||a.coltime,'yyyymmddhh24miss'),'yyyy-mm-dd hh24:mi:ss') as coldate  " + "from  "
                    + "t_doordtl a "
                    + "left join t_customer b on a.custid=b.custid " + "left join "
                    + "t_building tb on b.buildingid=tb.buildingid " + "left join  "
                    + "tb_region tr on a.regionid = tr.regionid "+ "left join  "
                    + "t_doordev d  on a.doorid = d.doorid, " + "t_keys c " + "where a.factoryid=c.factoryid  ";
            if (!startTranDate.equals("")) {
                queryString += "  and a.transdate>=:startTranDate and a.transdate<=:endTranDate ";
            }
            if (!startTranTime.equals("")) {
                queryString += "  and a.transtime>=:startTranTime and a.transtime<=:endTranTime ";
            }
            if (!stuempno.equals("")) {
                queryString += " and b.stuempno like :stuempno ";
            }
            if (!custname.equals("")) {
                queryString += " and b.custname like :custname ";
            }
            if (!buildingid.equals("")) {
                queryString += " and tb.buildingid = :buildingid ";
            }
            if (!regionid.equals("")){
                queryString += "and tr.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid =:operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  where tmp.regionid=:regionid)";
            }else {
                queryString += "and tr.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid =:operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  )";
            }
            if (!doorName.equals("")) {
                queryString += " and d.doorName like :doorName ";
            }
            if (!factoryId.equals("all")) {
                queryString += " and c.factoryId =:factoryId ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            Query query = entityManager.createNativeQuery(queryString, TDoordtlInfo.class);
            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!startTranTime.equals("")) {
                query.setParameter("startTranTime", startTranTime);
                query.setParameter("endTranTime", endTranTime);
            }
            if (!stuempno.equals("")) {
                query.setParameter("stuempno", "%" + stuempno + "%");
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
            }
            query.setParameter("operRegionid", operRegionid);
            if (!regionid.equals("")){
                query.setParameter("regionid", regionid);
            }
            if (!doorName.equals("")) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!factoryId.equals("all")) {
                query.setParameter("factoryId", factoryId);
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            List<TDoordtlInfo> list = query.getResultList();
            return list;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional
    @Override
    public Pagination findSystemTDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno, String custname, String buildingid, String doorName, String factoryId, String streamstatus, int pageNo, int pageSize, String regionid) {
        String queryString = "select a.doorid, d.doorname,a.stuempno,a.custname,a.transdate||a.transtime transdate,tb.buildingname,tr.regionname, "
                + "case when a.status='0' then '失败' else '成功' end status,a.coldate||a.coltime coldate,a.dtldesc,a.cardphyid  "
                + "from t_doordtl a left join t_doordev d  on a.doorid = d.doorid "
                + "left join t_building tb on a.buildingid=tb.buildingid "
                + "left join tb_region tr on a.regionid=tr.regionid "
                + "where 1>0 ";
        if (!startTranDate.equals("")) {
            queryString += " and transdate between :startTranDate and :endTranDate ";
        }
        if (!stuempno.equals("")) {
            queryString += " and a.stuempno like :stuempno ";
        }
        if (!custname.equals("")) {
            queryString += " and a.custname like :custname ";
        }
        if (!doorName.equals("")) {
            queryString += " and d.doorName like :doorName ";
        }
        if (!streamstatus.equals("all")) {
            queryString += " and a.status =:streamstatus ";
        }
        if(!buildingid.equals("")){
            queryString += " and tb.buildingid = :buildingid";
        }
        if (!regionid.equals("")){
            queryString += "and tr.regionid in  "
                    +"("
                    + "with recursive tmp as  "
                    + "("
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                    + "union all  "
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                    + ") select regionid from tmp  )";
        }
        queryString += " order by a.transdate DESC";
        Query query = entityManager.createNativeQuery(queryString, TDoordtlInfo.class);
        if (!startTranDate.equals("")) {
            query.setParameter("startTranDate", startTranDate);
            query.setParameter("endTranDate", endTranDate);
        }
        if (!stuempno.equals("")) {
            query.setParameter("stuempno", stuempno);
        }
        if (!custname.equals("")) {
            query.setParameter("custname", "%" + custname + "%");
        }
        if (!doorName.equals("")) {
            query.setParameter("doorName", "%" + doorName + "%");
        }
        if (!streamstatus.equals("all")) {
            query.setParameter("streamstatus", streamstatus);
        }
        if(!buildingid.equals("")){
            query.setParameter("buildingid",buildingid);
        }
        if (!regionid.equals("")){
            query.setParameter("regionid", regionid);
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TDoordtlInfo> list = query.getResultList();
        page.setList(list);
        int totalCount = getSystemCount(startTranDate, endTranDate, startTranTime, endTranTime, stuempno, custname,
                buildingid, doorName, factoryId, streamstatus,regionid);
        page.setTotalCount(totalCount);
        return page;
    }




    private int getSystemCount(String startTranDate, String endTranDate, String startTranTime, String endTranTime,
                         String stuempno, String custname, String buildingid, String doorName,
                         String factoryId, String streamstatus,String regionid) {
        try {
            String queryString = "select count(*) as cnt "
                    + " from t_doordtl a "
                    + " left join t_doordev d  on a.doorid = d.doorid "
                    + "left join t_building tb on a.buildingid=tb.buildingid "
                    + "left join tb_region tr on a.regionid=tr.regionid "
                    + " where 1>0";

            if (!startTranDate.equals("")) {
                queryString += " and transdate between :startTranDate and :endTranDate ";
            }
            if (!stuempno.equals("")) {
                queryString += " and a.stuempno = :stuempno ";
            }
            if (!custname.equals("")) {
                queryString += " and a.custname like :custname ";
            }
            if (!doorName.equals("")) {
                queryString += " and d.doorName like :doorName ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            if(!buildingid.equals("")){
                queryString += " and tb.buildingid = :buildingid";
            }
            if (!regionid.equals("")){
                queryString += "and tr.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp  )";
            }
            Query query = entityManager.createNativeQuery(queryString);
            query.setMaxResults(5);
            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!stuempno.equals("")) {
                query.setParameter("stuempno", stuempno);
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
			if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
			}
            if (!doorName.equals("")) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            if(!regionid.equals("")){
                query.setParameter("regionid",regionid);
            }
            List list = query.getResultList();
            int cnt = 0;
            if (list!=null && list.size()>0){
                cnt = Integer.parseInt(list.get(0).toString());
            }
            return cnt;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }


    @Transactional
    @Override
    public Pagination findOperatorTDoordtl(String operid, String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno, String custname, String buildingid, String doorName, String factoryId, String streamstatus, int pageNo, int pageSize, String regionid,String operRegionid) {
        try{
            String queryString = "select a.doorid,d.doorname,a.stuempno,a.custname,a.transdate||a.transtime transdate,"
                    + " case when a.status='0' then '失败' else '成功' end status,a.coldate||a.coltime coldate,a.dtldesc,a.cardphyid,tb.buildingname,tr.regionname "
                    + " from t_doordtl a left join t_doordev d on a.doorid = d.doorid"
                    + " left join t_operdevice od on a.doorid = od.deviceid"
                    + "left join t_building tb on a.buildingid=tb.buildingid "
                    + "left join tb_region tr on a.regionid=tr.regionid "
                    + " where 1>0 ";
            if (!startTranDate.equals("")) {
                queryString += " and transdate between :startTranDate and :endTranDate ";
            }
            if (!stuempno.equals("")) {
                queryString += " and a.stuempno like :stuempno ";
            }
            if (!custname.equals("")) {
                queryString += " and a.custname like :custname ";
            }
            if (!doorName.equals("")) {
                queryString += " and d.doorName like :doorName ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            if(!buildingid.equals("")){
                queryString += " and tb.buildingid = :buildingid";
            }
            if (!regionid.equals("")){
                queryString += "and tr.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp where tmp.regionid = :regionid )";
            }else {
                queryString += "and tr.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp )";
            }
            queryString += " order by transdate DESC";
            Query query = entityManager.createNativeQuery(queryString, TDoordtlInfo.class);

            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!stuempno.equals("")) {
                query.setParameter("stuempno", stuempno);
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!doorName.equals("")) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
            }
            query.setParameter("operRegionid", operRegionid);
            if(regionid.equals("")){
                query.setParameter("regionid",regionid);
            }
            pageNo = pageNo <= 0 ? 1 : pageNo;
            query.setFirstResult((pageNo - 1) * pageSize);
            query.setMaxResults(pageSize);
            Pagination page = new Pagination();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            List<TDoordtlInfo> list = query.getResultList();
            page.setList(list);
            int totalCount = getOperatorCount(startTranDate, endTranDate, startTranTime, endTranTime, stuempno, custname,
                    buildingid, doorName, factoryId, streamstatus,regionid,operRegionid);
            page.setTotalCount(totalCount);
            return page;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    private int getOperatorCount(String startTranDate, String endTranDate, String startTranTime, String endTranTime,
                         String stuempno, String custname, String buildingid, String doorName,
                         String factoryId, String streamstatus,String regionid,String operRegionid) {
        try {
            String queryString = "select count(*) as cnt "
                    + " from t_doordtl a "
                    + " left join t_doordev d  on a.doorid = d.doorid "
                    + " left join t_operdevice od on a.doorid = od.deviceid"
                    + " left join t_building tb on a.buildingid=tb.buildingid "
                    + " left join tb_region tr on a.regionid=tr.regionid "
                    + " where 1>0 ";

            if (!startTranDate.equals("")) {
                queryString += " and transdate between :startTranDate and :endTranDate ";
            }
            if (!stuempno.equals("")) {
                queryString += " and a.stuempno = :stuempno ";
            }
            if (!custname.equals("")) {
                queryString += " and a.custname like :custname ";
            }
            if (!doorName.equals("")) {
                queryString += " and d.doorName like :doorName ";
            }
            if (!streamstatus.equals("all")) {
                queryString += " and a.status =:streamstatus ";
            }
            if(!buildingid.equals("")){
                queryString += " and tb.buildingname like :buildingname";
            }
            if (!regionid.equals("")){
                queryString += "and tr.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid like :operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp where tmp.regionid=:regionid )";
            }else {
                queryString += "and tr.regionid in  "
                        +"("
                        + "with recursive tmp as  "
                        + "("
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid like :operRegionid  "
                        + "union all  "
                        + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                        + ") select regionid from tmp )";
            }
            Query query = entityManager.createNativeQuery(queryString);
            query.setMaxResults(5);
            if (!startTranDate.equals("")) {
                query.setParameter("startTranDate", startTranDate);
                query.setParameter("endTranDate", endTranDate);
            }
            if (!stuempno.equals("")) {
                query.setParameter("stuempno", stuempno);
            }
            if (!custname.equals("")) {
                query.setParameter("custname", "%" + custname + "%");
            }
            if (!doorName.equals("")) {
                query.setParameter("doorName", "%" + doorName + "%");
            }
            if (!streamstatus.equals("all")) {
                query.setParameter("streamstatus", streamstatus);
            }
            if (!buildingid.equals("")) {
                query.setParameter("buildingid", buildingid);
            }
            query.setParameter("operRegionid", operRegionid);
            if(!regionid.equals("")){
                query.setParameter("regionid",regionid);
            }
            List list = query.getResultList();
            int cnt = 0;
            if (list!=null && list.size()>0){
                cnt = Integer.parseInt(list.get(0).toString());
            }
            return cnt;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}
