package com.supwisdom.dlpay.mainservice.service;

import com.supwisdom.dlpay.mainservice.bean.TDoorcardlstInfo;
import com.supwisdom.dlpay.mainservice.bean.TDoordtlInfo;
import com.supwisdom.dlpay.mainservice.domain.TKey;
import com.supwisdom.dlpay.system.page.Pagination;

import java.util.List;

public interface WebInterfaceService {

    //获取所有厂商
    public List<TKey> getAllKeys() throws Exception;

    //根据查询条件分页获取所有流水
    public Pagination getSystemCardListFrSearch(String factoryId, String allocatStartDate, String allocatEndDate,
                                             String doorName, String custName, String stuempNo, String syncStatus,String operFlag, String buildingid,String regionid, int pageNo, int pageSize);

    //根据查询条件分页获取管理员权限的流水
    public Pagination getOperatorCardListFrSearch(String factoryId, String allocatStartDate, String allocatEndDate,
                                                  String doorName, String custName, String stuempNo, String syncStatus,String operFlag, String buildingid,String regionid, int pageNo, int pageSize,String operRegionid);

    //根据查询条件获取所有导出表单信息
    public List<TDoorcardlstInfo> getSystemCardListMap(String factoryId, String allocatStartDate, String allocatEndDate,
                                                    String doorName, String custName, String stuempNo, String syncStatus, String operFlag, String buildingid,String regionid);

    public List<TDoorcardlstInfo> getOperatorCardListMap(String factoryId, String allocatStartDate, String allocatEndDate,
                                                       String doorName, String custName, String stuempNo, String syncStatus, String operFlag, String buildingid,String regionid,String operRegionid);

    //根据名单编号将已同步的名单修改为未同步使其重新同步
    public void updateDoorcardlstToNoWithIds (List<Long> listIds);

    //根据查询条件获取所有导出Excel数据
    public List<TDoordtlInfo> findSystemExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno,
                                                     String custname, String buildingid, String regionid, String doorName, String factoryId, String streamstatus);

    //根据查询条件获取管理员权限的Excel数据
    public List<TDoordtlInfo> findOperatorExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno,
                                                             String custname, String buildingid, String regionid, String doorName, String factoryId, String streamstatus,String operRegionid);

    //根据查询条件获取系统管理员流水数据
    public Pagination findSystemTDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno,
                                         String custname, String buildingid, String doorName, String factoryId, String streamstatus, int pageNo, int pageSize,String regionid);

    //根据查询条件获取管理员权限相应流水数据
    public Pagination findOperatorTDoordtl(
            String operid,String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno,
            String custname, String buildingid, String doorName, String factoryId, String streamstatus, int pageNo, int pageSize,String regionid,String operRegionid);
}
