package com.supwisdom.dlpay.mainservice.service.impl;

import com.supwisdom.dlpay.mainservice.bean.TDoorcardlstInfo;
import com.supwisdom.dlpay.mainservice.bean.TDoordtlInfo;
import com.supwisdom.dlpay.mainservice.dao.CardListDao;
import com.supwisdom.dlpay.mainservice.dao.DoordtlDao;
import com.supwisdom.dlpay.mainservice.dao.KeyDao;
import com.supwisdom.dlpay.mainservice.domain.TKey;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class WebInterfaceServiceImpl implements WebInterfaceService {
    @Autowired
    KeyDao keyDao;
    @Autowired
    CardListDao cardListDao;
    @Autowired
    DoordtlDao doordtlDao;

    @Override
    public List<TKey> getAllKeys() throws Exception {
        return keyDao.getAllKeys();
    }

    @Override
    public Pagination getSystemCardListFrSearch(String factoryId, String allocatStartDate, String allocatEndDate, String doorName, String custName, String stuempNo, String syncStatus,  String operFlag, String buildingid,String regionid, int pageNo, int pageSize) {
        return cardListDao.getSystemCardListFrSearch(factoryId, allocatStartDate, allocatEndDate, doorName, custName, stuempNo, syncStatus, operFlag, buildingid,regionid, pageNo, pageSize);
    }

    @Override
    public Pagination getOperatorCardListFrSearch(String factoryId, String allocatStartDate, String allocatEndDate, String doorName, String custName, String stuempNo, String syncStatus, String operFlag, String buildingid, String regionid, int pageNo, int pageSize, String operRegionid) {
        return cardListDao.getOperatorCardListFrSearch(factoryId, allocatStartDate, allocatEndDate, doorName, custName, stuempNo, syncStatus, operFlag, buildingid, regionid, pageNo, pageSize, operRegionid);
    }

    @Override
    public List<TDoorcardlstInfo> getSystemCardListMap(String factoryId, String allocatStartDate, String allocatEndDate, String doorName, String custName, String stuempNo, String syncStatus,  String operFlag, String buildingid,String regionid) {
        return cardListDao.getSystemCardListMap(factoryId, allocatStartDate, allocatEndDate, doorName, custName, stuempNo, syncStatus,  operFlag, buildingid,regionid);
    }

    @Override
    public List<TDoorcardlstInfo> getOperatorCardListMap(String factoryId, String allocatStartDate, String allocatEndDate, String doorName, String custName, String stuempNo, String syncStatus, String operFlag, String buildingid, String regionid, String operRegionid) {
        return cardListDao.getOperatorCardListMap(factoryId, allocatStartDate, allocatEndDate, doorName, custName, stuempNo, syncStatus, operFlag, buildingid, regionid, operRegionid);
    }

    @Override
    public void updateDoorcardlstToNoWithIds(List<Long> listIds) {
        cardListDao.updateDoorcardlstToNoWithIds(listIds);
    }

    @Override
    public List<TDoordtlInfo> findSystemExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno, String custname, String buildingid, String regionid, String doorName, String factoryId, String streamstatus) {
        return doordtlDao.findSystemExportExcelDoordtl(startTranDate, endTranDate, startTranTime, endTranTime, stuempno, custname, buildingid, regionid, doorName, factoryId, streamstatus);
    }

    @Override
    public List<TDoordtlInfo> findOperatorExportExcelDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno, String custname, String buildingid, String regionid, String doorName, String factoryId, String streamstatus, String operRegionid) {
        return doordtlDao.findOperatorExportExcelDoordtl(startTranDate, endTranDate, startTranTime, endTranTime, stuempno, custname, buildingid, regionid, doorName, factoryId, streamstatus, operRegionid);
    }

    @Override
    public Pagination findSystemTDoordtl(String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno, String custname, String buildingid, String doorName, String factoryId, String streamstatus, int pageNo, int pageSize, String regionid) {
        return doordtlDao.findSystemTDoordtl(startTranDate, endTranDate, startTranTime, endTranTime, stuempno, custname, buildingid, doorName, factoryId, streamstatus, pageNo, pageSize, regionid);
    }

    @Override
    public Pagination findOperatorTDoordtl(String operid, String startTranDate, String endTranDate, String startTranTime, String endTranTime, String stuempno, String custname, String buildingid, String doorName, String factoryId, String streamstatus, int pageNo, int pageSize, String regionid,String operRegionid) {
        return doordtlDao.findOperatorTDoordtl(operid, startTranDate, endTranDate, startTranTime, endTranTime, stuempno, custname, buildingid, doorName, factoryId, streamstatus, pageNo, pageSize, regionid,operRegionid);
    }
}
