package com.supwisdom.dlpay.ncmgr.dao;

import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;

import java.util.List;

public interface NcDeviceDao {
    public Pagination getSystemNcDeviceWithPage(String devname, int pageNo, int pageSize, String buildingid,String regionid, String devtype);

    public List<TBuilding> getAllBuilding();

    public List<TRegion> getAllRegion();

    public TBuilding getBuidingById(String id);

    public List<TNcDevice> getSystemDevByType(String type);

    public List<TNcDevice> getOperatorDevByType(String type,String regionid);

    public TNcDevice findDevById(int id);

    public TNcDevice validDevName(int devid,String devname);

    public TNcDevice validDevPhyid(int devid,String devPhyid);

    public TNcDevice validDevNo(int fdevid,int devno,int devid);

    public boolean updateDevice(TNcDevice bean);

    public int getMaxId();

    public boolean saveDevice(TNcDevice bean);

    public TNcDevice getDevInfoByDevid(int devid);

    public boolean delDevById(int devid);

    public List<TNcDevice> findAllNcDevices();

    public TNcDevice getDevByBuildingid(String buildingid);

    public List<TNcDevice> findOperatorDevices(String operRegionid);
}
