package com.supwisdom.dlpay.ncmgr.dao.impl;

import com.supwisdom.dlpay.ncmgr.dao.NcCardListDao;
import com.supwisdom.dlpay.ncmgr.domain.TNcCardlist;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class NcCardListDaoImpl implements NcCardListDao {

    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public TNcCardlist getCleanList(String devid) {
        String sql = "select t from TNcCardlist t where t.deviceid=:devid and t.operflag = 'C'";
        TypedQuery<TNcCardlist> query = entityManager.createQuery(sql, TNcCardlist.class);
        query.setParameter("devid", devid);
        List<TNcCardlist> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean saveCardlist(TNcCardlist bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public void updateForListReload(String devid) {
        String sql = "update T_NC_CARDLIST set syncflag='N' ,synctime='' "+
                " where deviceid=?1 and operflag != 'C'";
        Query query = entityManager.createNativeQuery(sql);
        query.setParameter(1, devid);
        query.executeUpdate();
    }
}
