package com.supwisdom.dlpay.ncmgr.dao.impl;

import com.supwisdom.dlpay.ncmgr.dao.NcDeviceDao;
import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class NcDeviceDaoImpl implements NcDeviceDao {

    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getSystemNcDeviceWithPage(String devname, int pageNo, int pageSize, String buildingid,String regionid, String devtype) {
        String sql ="select * from T_Nc_Device bean "
                +" left join t_building tb on bean.buildingid=tb.buildingid"
                +" left join tb_region tr on tr.regionid=tb.regionid"
                +" where 1>0 and operflag='A'";
        if(!devname.equals("")){
            sql+="and devname like :devname ";
        }
        if(!buildingid.equals("")){
            sql+="and  bean.buildingid = :buildingid ";
        }
        if (!regionid.equals("")){
            sql += "and tr.regionid in  "
                    +"("
                    + "with recursive tmp as  "
                    + "("
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                    + "union all  "
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                    + ") select regionid from tmp  )";
        }
        if(!devtype.equals("")){
            sql+="and  devtype = :devtype ";
        }
        sql+="order by devtype";
        Query query = entityManager.createNativeQuery(sql,TNcDevice.class);

        if(!devname.equals("")){
            query.setParameter("devname", "%"+devname+"%");
        }
        if(!buildingid.equals("")){
            query.setParameter("buildingid", buildingid);
        }
        if(!devtype.equals("")){
            query.setParameter("devtype", devtype);
        }
        if (!("").equals(regionid)){
            query.setParameter("regionid", regionid);
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TNcDevice> list = query.getResultList();
        page.setList(list);
        int totalCount = getSystemNcDeviceCount(devname, buildingid, regionid, devtype);
        page.setTotalCount(totalCount);
        return page;
    }


    private int getSystemNcDeviceCount(String devname, String buildingid,String regionid, String devtype){
        String sql ="select count(bean.deviceid) from T_Nc_Device bean "
                +" left join t_building tb on bean.buildingid=tb.buildingid"
                +" left join tb_region tr on tr.regionid=tb.regionid"
                +" where 1>0 and operflag='A'";
        if(!devname.equals("")){
            sql+="and devname like :devname ";
        }
        if(!buildingid.equals("")){
            sql+="and  bean.buildingid = :buildingid ";
        }
        if (!regionid.equals("")){
            sql += "and tr.regionid in  "
                    +"("
                    + "with recursive tmp as  "
                    + "("
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr where regionid = :regionid  "
                    + "union all  "
                    + "select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  "
                    + ") select regionid from tmp  )";
        }
        if(!devtype.equals("")){
            sql+="and  devtype = :devtype ";
        }
        Query query = entityManager.createNativeQuery(sql);
        if(!devname.equals("")){
            query.setParameter("devname", "%"+devname+"%");
        }
        if(!buildingid.equals("")){
            query.setParameter("buildingid", buildingid);
        }
        if(!devtype.equals("")){
            query.setParameter("devtype", devtype);
        }
        if (!("").equals(regionid)){
            query.setParameter("regionid", regionid);
        }
        List list = query.getResultList();
        int cnt = 0;
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }


    @Transactional
    @Override
    public List<TBuilding> getAllBuilding() {
        String sql = " select b FROM TBuilding b WHERE b.flag='A' ";
        TypedQuery<TBuilding> query = entityManager.createQuery(sql, TBuilding.class);
        List<TBuilding> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public List<TRegion> getAllRegion() {
        String sql = " select b FROM TRegion b WHERE b.flag=1 ";
        TypedQuery<TRegion> query = entityManager.createQuery(sql, TRegion.class);
        List<TRegion> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public TBuilding getBuidingById(String id) {
        String sql = "select b from TBuilding b where b.flag='A' and b.buildingid=:buildingid";
        TypedQuery<TBuilding> query = entityManager.createQuery(sql, TBuilding.class);
        query.setParameter("buildingid", id);
        List<TBuilding> list = query.getResultList();
        if (list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public List<TNcDevice> getSystemDevByType(String type) {
        String sql = "select r from TNcDevice r where r.devtype=?1 and r.operflag='A' order by r.devname";
        Query query = entityManager.createQuery(sql);
        query.setParameter(1, type);
        List<TNcDevice> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public List<TNcDevice> getOperatorDevByType(String type, String regionid) {
        String sql = "select bean.deviceid,bean.devphyid,bean.devname,bean.ip,bean.operflag,bean.syncflag,bean.synctime," +
                "bean.updtime,bean.fdevid,bean.devtype,bean.devno,bean.usetype,bean.buildingid,bean.buildingname,bean.regionid " +
                " from T_NC_DEVICE bean where devtype=:devtype and operflag='A' "+
                "and bean.regionid in  " +
                "( with recursive tmp as  ( select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid ) " +
                "  select regionid from tmp  )";

        Query query = entityManager.createNativeQuery(sql, TNcDevice.class);
        query.setParameter("devtype", type);
        query.setParameter(regionid, regionid);
        List<TNcDevice> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public TNcDevice findDevById(int id) {
        String sql = " select r from TNcDevice r where  r.deviceid=:deviceid";
        Query query = entityManager.createQuery(sql,TNcDevice.class);
        query.setParameter("deviceid", id);
        List<TNcDevice> list = query.getResultList();
        if (list.size()>0) {
            TNcDevice device = list.get(0);
            return device;
        }else {
            return null;
        }
    }

    @Transactional
    @Override
    public TNcDevice validDevName(int devid, String devname) {
        String sql="";
        if (devid==0){
            sql="select d from TNcDevice d where d.devname=:devname";
        }else {
            sql="select d from TNcDevice d where d.deviceid != :devid  and d.devname=:devname";
        }
        TypedQuery<TNcDevice> query = entityManager.createQuery(sql, TNcDevice.class);
        if (devid>0){
            query.setParameter("devid", devid);
        }
        query.setParameter("devname", devname);
        List<TNcDevice> list = query.getResultList();
        if (list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public TNcDevice validDevPhyid(int devid, String devPhyid) {
        String sql="";
        if (devid==0){
            sql="select d from TNcDevice d where d.devphyid=:devphyid";
        }else {
            sql="select d from TNcDevice d where d.deviceid!=:devid and d.devphyid=:devphyid";
        }
        TypedQuery<TNcDevice> query = entityManager.createQuery(sql, TNcDevice.class);
        if (devid>0){
            query.setParameter("devid", devid);
        }
        query.setParameter("devphyid", devPhyid);
        List<TNcDevice> list = query.getResultList();
        if (list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public TNcDevice validDevNo(int fdevid, int devno, int devid) {
        String sql="";
        if (devid==0){
            sql="select d from TNcDevice d where d.fdevid=:fdevid and d.devno=:devno ";
        }else {
            sql="select d from TNcDevice d where d.fdevid=:fdevid and d.devno=:devno and d.deviceid<>:devid ";
        }
        TypedQuery<TNcDevice> query = entityManager.createQuery(sql, TNcDevice.class);
        if (devid>0){
            query.setParameter("devid", devid);
        }
        query.setParameter("fdevid", fdevid);
        query.setParameter("devno", devno);
        List<TNcDevice> list = query.getResultList();
        if (list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateDevice(TNcDevice bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public int getMaxId() {
        String sql = " select Max(deviceid) from t_nc_device";
        Query query = entityManager.createNativeQuery(sql);
        Object result = query.getSingleResult();
        if (result!=null){
            return (int)result;
        }
        return 1;
    }

    @Transactional
    @Override
    public boolean saveDevice(TNcDevice bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TNcDevice getDevInfoByDevid(int devid) {
        String sql = "select t.deviceid,t.devno,t.devname,t.fdevid,t.devtype,t.ip," +
                "t.operflag,t.syncflag,t.synctime,t.updtime,t.buildingid,t.buildingname,t.regionid," +
                " t.usetype,dev.devphyid from t_nc_device t left join t_nc_device" +
                " dev on t.fdevid=dev.deviceid where t.deviceid=?1";
        Query query = entityManager.createNativeQuery(sql, TNcDevice.class);
        query.setParameter(1,devid);
        List list = query.getResultList();
        if (list.size()>0){
            return (TNcDevice) list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean delDevById(int devid) {
        boolean flag=false;
        try {
            String sql = "delete from T_Nc_Device where deviceid=?1";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter(1, devid);
            query.executeUpdate();
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TNcDevice> findAllNcDevices() {
        String sql = "select r from TNcDevice r order by r.deviceid";
        TypedQuery<TNcDevice> query = entityManager.createQuery(sql, TNcDevice.class);
        List<TNcDevice> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public TNcDevice getDevByBuildingid(String buildingid) {
        String sql = "select bean from TNcDevice bean where bean.operflag='A' and bean.buildingid=:buildingid";
        TypedQuery<TNcDevice> query = entityManager.createQuery(sql, TNcDevice.class);
        query.setParameter("buildingid" , buildingid);
        List<TNcDevice> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public List<TNcDevice> findOperatorDevices(String operRegionid) {
        String sql = "select bean.deviceid,bean.devphyid,bean.devname,bean.ip,bean.operflag,bean.syncflag,bean.synctime," +
                "bean.updtime,bean.fdevid,bean.devtype,bean.devno,bean.usetype,bean.buildingid,bean.buildingname,bean.regionid " +
                " from T_NC_DEVICE bean where  operflag='A' "+
                "and bean.regionid in  " +
                "( with recursive tmp as  ( select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                " where regionid= :operRegionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid ) " +
                "  select regionid from tmp  )";
        Query query = entityManager.createNativeQuery(sql, TNcDevice.class);
        query.setParameter("operRegionid", operRegionid);
        List<TNcDevice> list = query.getResultList();
        return list;
    }
}
