package com.supwisdom.dlpay.query.controller;

import cn.afterturn.easypoi.entity.vo.NormalExcelConstants;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.view.PoiBaseView;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.mainservice.bean.TDoordtlInfo;
import com.supwisdom.dlpay.mainservice.domain.TKey;
import com.supwisdom.dlpay.mainservice.service.WebInterfaceService;
import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.system.domain.TDictionaryId;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/query")
public class QueryController {

    @Autowired
    WebInterfaceService webInterfaceService;

    @Autowired
    SystemService systemService;

    @Autowired
    NcService ncService;

    @RequestMapping("/tdoorstream")
    public String tdoorstream(ModelMap model){
        return "query/tdoorstream";
    }

    /**
     * 填充流水查询列表
     * @return
     * @throws Exception
     */
    @ResponseBody
    @RequestMapping(value = "/getSearchFactoryIdList")
    public Map getSearchFactoryIdList(@AuthenticationPrincipal TOperator operUser) throws Exception {
        Map map = new HashMap<>();
        try {
            //所有厂商
            List<TKey> allFactoryId = webInterfaceService.getAllKeys();
            map.put("allFactoryId", allFactoryId);
            //流水状态
            List<TDictionaryId> dtlStatus = systemService.findTDictionaryByType(20);
            map.put("dtlStatus", dtlStatus);

            String opertype = operUser.getOpertype();
            List<TRegion> regions = null;
            List<TBuilding> buildings = null;
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))) {
                regions = systemService.getAllRegions();
                buildings = ncService.getAllBuilding();
                map.put("regions", regions);
                map.put("buildings", buildings);
            }else if (!StringUtil.isEmpty(operUser.getRegionid())){
                regions = systemService.getRegionListById(operUser.getRegionid());
                map.put("regions", regions);
                buildings = systemService.getBuildingByRegionId(operUser.getRegionid());
                map.put("buildings", buildings);
            }

        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }


    /**
     * 获取需Excel导出流水数据
     * @param request
     * @param response
     * @param startTranDate
     * @param endTranDate
     * @param startTranTime
     * @param endTranTime
     * @param stuempno
     * @param custname
     * @param buildingid
     * @param regionid
     * @param doorName
     * @param factoryId
     * @param streamstatus
     */
    @ResponseBody
    @RequestMapping(value = "/exportexcel")
    public void exportexcel(HttpServletRequest request, HttpServletResponse response,
                            @RequestParam(value = "startTranDate", required = false, defaultValue = "") String startTranDate,
                            @RequestParam(value = "endTranDate", required = false, defaultValue = "") String endTranDate,
                            @RequestParam(value = "startTranTime", required = false, defaultValue = "000000") String startTranTime,
                            @RequestParam(value = "endTranTime", required = false, defaultValue = "235959") String endTranTime,
                            @RequestParam(value = "stuempno", required = false, defaultValue = "") String stuempno,
                            @RequestParam(value = "custname", required = false, defaultValue = "") String custname,
                            @RequestParam(value = "buildingid", required = false, defaultValue = "") String buildingid,
                            @RequestParam(value = "regionid",required = false,defaultValue = "") String regionid,
                            @RequestParam(value = "doorName", required = false, defaultValue = "") String doorName,
                            @RequestParam(value = "factoryId", required = false, defaultValue = "all") String factoryId,
                            @RequestParam(value = "streamstatus", required = false, defaultValue = "all") String streamstatus,
                            @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        try {
            if (startTranDate.equals("Invalid date")) {
                startTranDate = "";
                endTranDate = "";
                startTranTime = "";
                endTranTime = "";
            }
            String opertype = operUser.getOpertype();
            /**
             * 1. 查询数据
             */
            // final int max_field = 9;
            // 保存表字段
            List<TDoordtlInfo> tDoordtlInfos = null;
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))) {
                tDoordtlInfos = webInterfaceService.findSystemExportExcelDoordtl(startTranDate, endTranDate, startTranTime,
                        endTranTime, stuempno, custname, buildingid, regionid, doorName, factoryId, streamstatus);
            }else if (!StringUtil.isEmpty(operUser.getRegionid())){
                tDoordtlInfos = webInterfaceService.findOperatorExportExcelDoordtl(startTranDate, endTranDate, startTranTime,
                        endTranTime, stuempno, custname, buildingid, regionid, doorName, factoryId, streamstatus,operUser.getRegionid());
            }
            /**
             * 2.设置表格属性: title:标题  sheetName:工作簿名 type:表格类型
             */
            ExportParams params = new ExportParams("设备流水列表", "设备流水", ExcelType.XSSF);
//		params.setFreezeCol(2);
            map.put(NormalExcelConstants.DATA_LIST, tDoordtlInfos);//设置值
            map.put(NormalExcelConstants.PARAMS, params);//设置属性
            map.put(NormalExcelConstants.CLASS, TDoordtlInfo.class);
            map.put(NormalExcelConstants.FILE_NAME, "设备流水名单");
            PoiBaseView.render(map, request, response, NormalExcelConstants.EASYPOI_EXCEL_VIEW);

        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "导出excel文件失败");
        }
    }

    /**
     * 获取流水信息
     * @param request
     * @param startTranDate
     * @param endTranDate
     * @param startTranTime
     * @param endTranTime
     * @param stuempno
     * @param custname
     * @param buildingid
     * @param doorName
     * @param factoryId
     * @param streamstatus
     * @param pageNo
     * @param pageSize
     * @param regionid
     * @param operUser
     * @return
     * @throws UnsupportedEncodingException
     */
    @ResponseBody
    @RequestMapping(value = "/getSearchDoorStreamList")
    public Map getSearchDoorStreamList( HttpServletRequest request,
                                          @RequestParam(value = "startTranDate", required = false, defaultValue = "") String startTranDate,
                                          @RequestParam(value = "endTranDate", required = false, defaultValue = "") String endTranDate,
                                          @RequestParam(value = "startTranTime", required = false, defaultValue = "000000") String startTranTime,
                                          @RequestParam(value = "endTranTime", required = false, defaultValue = "235959") String endTranTime,
                                          @RequestParam(value = "stuempno", required = false, defaultValue = "") String stuempno,
                                          @RequestParam(value = "custname", required = false, defaultValue = "") String custname,
                                          @RequestParam(value = "buildingid", required = false, defaultValue = "") String buildingid,
                                          @RequestParam(value = "doorName", required = false, defaultValue = "") String doorName,
                                          @RequestParam(value = "factoryId", required = false, defaultValue = "all") String factoryId,
                                          @RequestParam(value = "streamstatus", required = false, defaultValue = "all") String streamstatus,
                                          @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                                          @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                                          @RequestParam(value = "regionid", required = false, defaultValue = "") String regionid,
                                          @AuthenticationPrincipal TOperator operUser)
            throws UnsupportedEncodingException {
        Map map = new HashMap();
        SimpleDateFormat ymd = new SimpleDateFormat("yyyyMMdd");
        boolean index = true;
        if (factoryId.equals("") || factoryId == null) {
            factoryId = "all";
        }
        try {
            if (startTranDate.equals("Invalid date")) {
                startTranDate = "";
                endTranDate = "";
                startTranTime = "";
                endTranTime = "";
            }
            String opertype = operUser.getOpertype();
            Pagination tDoordtlInfo = new Pagination();
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))) {
                tDoordtlInfo = webInterfaceService.findSystemTDoordtl(startTranDate, endTranDate, startTranTime,
                        endTranTime, stuempno, custname, buildingid, doorName, factoryId, streamstatus, pageNo, pageSize,regionid);
            }else if (!StringUtil.isEmpty(operUser.getRegionid())){
                tDoordtlInfo = webInterfaceService.findOperatorTDoordtl(operUser.getOperid(), startTranDate, endTranDate, startTranTime,
                        endTranTime, stuempno, custname, buildingid, doorName, factoryId, streamstatus, pageNo, pageSize, regionid,operUser.getRegionid());
            }
            map.put("tDoordtlInfo", tDoordtlInfo);
            map.put("index", index);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }


}
