package com.supwisdom.dlpay.system.common;

import com.supwisdom.dlpay.system.service.DictionaryDataService;
import com.supwisdom.dlpay.util.ConstantUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component("dictPool")
@Scope("singleton")
public class DictPool {
  private static HashMap<String, Object> dictmap = new HashMap<>();

  @Autowired
  private DictionaryDataService dictionaryDataService;

  public static HashMap<Object, Object> getDictMap(String key) {
    synchronized (dictmap) {
      return (HashMap<Object, Object>) dictmap.get(key);
    }
  }

  public static void updateDict(String dictType, Map<String, String> value) {
    synchronized (dictmap) {
      dictmap.put(dictType, value);
    }
  }

  public void init() {
    dictmap.put("allSourcetypeList", dictionaryDataService.getSystemAllSourcetype());
    dictmap.put("allReverseflagList", dictionaryDataService.getDictionaryByDicttype(ConstantUtil.DICTTYPE_NO1));

  }
}
