package com.supwisdom.dlpay.system.controller;

import com.google.gson.Gson;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevice;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.system.bean.AllotBuildingBean;
import com.supwisdom.dlpay.system.bean.BuildingBean;
import com.supwisdom.dlpay.system.bean.RegionBean;
import com.supwisdom.dlpay.system.domain.*;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.SystemService;
import com.supwisdom.dlpay.util.RedisUtil;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/system")
public class SystemController {
    protected static Logger logger = Logger.getLogger(SystemController.class);

    @Autowired
    private SystemService systemService;
    @Autowired
    private NcService ncService;

    @RequestMapping("/dictionary")
    public String dictionary(ModelMap model){
        return "system/dictionary";
    }

    @RequestMapping("/queue")
    public String queue(ModelMap model){
        return "system/queue";
    }

    @RequestMapping("/regionindex")
    public String regionindex(){
        return "system/region";
    }

    @RequestMapping("/buildingindex")
    public String buildingindex(){
        return "system/building";
    }

    /**
     * 获取字典列表
     * @param dicttype
     * @param dictcaption
     * @param pageNo
     * @param pageSize
     * @param request
     * @return
     */
    @RequestMapping(value = "/getDictionary")
    @ResponseBody
    public Map getDictionary(@RequestParam(value = "dicttype", defaultValue = "all") String dicttype,
                             @RequestParam(value = "dictcaption", defaultValue = "") String dictcaption,
                             @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                             @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                             HttpServletRequest request) {
        Map map = new HashMap();
        try {
            Pagination page = new Pagination();
            page = systemService.findDictionary(dicttype, dictcaption, pageNo, pageSize);

            map.put("pageResult", page);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 获取所有字典类型
     * @return
     */
    @RequestMapping(value = "/getDictionaryType")
    @ResponseBody
    public Map getDictionaryType(){
        Map map = new HashMap();
        try {
            List<DictionaryType> type = systemService.findDictionaryType();
            map.put("DictId", type);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 保存字典值
     * @param dicttype
     * @param dicttypename
     * @param dictval
     * @param dictcaption
     * @param request
     * @return
     */
    @RequestMapping(value = "/saveDictionary")
    @ResponseBody
    public Map saveDictionary(@RequestParam(value = "dicttype", required = true) String dicttype,
                                   @RequestParam(value = "dicttypename", defaultValue="") String dicttypename,
                                   @RequestParam(value = "dictval", required = true) String dictval,
                                   @RequestParam(value = "dictcaption", defaultValue="") String dictcaption,
                                   HttpServletRequest request){
        Map map = new HashMap<>();
        try {
            List<TDictionaryId> tDictionaryByType = systemService.findTDictionaryByType(Integer.valueOf(dicttype));
            for (TDictionaryId tDictionaryId : tDictionaryByType) {
                if(tDictionaryId.getDictval().equals(dictval)){
                    map.put("errStr", "数据字典值已存在，保存失败！");
                    return map;
                }
            }
            systemService.saveDictionary(dicttype,dicttypename,dictval,dictcaption);
            RedisUtil.lrem("dict_"+dicttype,0,dictval+"_"+dictcaption);
            RedisUtil.rpush("dict_"+dicttype,dictval+"_"+dictcaption);
            if (Integer.valueOf(dicttype)==17){
                RedisUtil.set("dict_dbcheck",dictval);
            }
            map.put("errStr", "");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "保存字典失败");
            logger.error("保存字典失败：");
        }
        return map;
    }

    /**
     * 更新字典值
     * @param dicttype
     * @param dicttypename
     * @param dictval
     * @param dictcaption
     * @param oriengaltype
     * @param oriengalval
     * @param request
     * @return
     */
    @RequestMapping(value = "/updateDictionary")
    @ResponseBody
    public Map updateDictionary(
            @RequestParam(value = "dicttype", required = true) String dicttype,
            @RequestParam(value = "dicttypename", defaultValue="") String dicttypename,
            @RequestParam(value = "dictval", required = true) String dictval,
            @RequestParam(value = "dictcaption", defaultValue="") String dictcaption,
            @RequestParam(value = "oriengaltype", required = true) String oriengaltype,
            @RequestParam(value = "oriengalval", required = true) String oriengalval,
            HttpServletRequest request) {
        Map map = new HashMap<>();
        try {
            List<TDictionaryId> byType1 = systemService.findByType(Integer.valueOf(oriengaltype), dictval);
            boolean flag = false;
            for (TDictionaryId tDictionaryId : byType1) {
                String dicttype1 = tDictionaryId.getDicttype().toString();
                String dictval1 = tDictionaryId.getDictval();
                String dictcaption1 = tDictionaryId.getDictcaption();
                if(dicttype1.equals(dicttype)&&dictval1.equals(dictval)&&dictcaption1.equals(dictcaption)){
                    flag=true;
                }
            }
            if(flag){
                map.put("errStr", "字典值重复，修改失败！");
                return map;
            }
            List<TDictionaryId> byType = systemService.findByType(Integer.valueOf(oriengaltype), oriengalval);
            systemService.updateDictionary(dicttype,dicttypename,dictval,dictcaption, oriengaltype, oriengalval);
            for (TDictionaryId tDictionaryId : byType) {
                RedisUtil.lrem("dict_"+tDictionaryId.getDicttype(),0,tDictionaryId.getDictval()+"_"+tDictionaryId.getDictcaption());
            }
            RedisUtil.rpush("dict_"+dicttype,dictval+"_"+dictcaption);

            if (Integer.valueOf(dicttype)==17){
                RedisUtil.set("dict_dbcheck",dictval);
            }
            map.put("errStr", "");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "修改字典失败");
            logger.error("修改字典失败：");
        }
        return map;
    }

    /**
     * 分页获取区域类别
     * @param request
     * @param response
     * @param pageNo
     * @param pageSize
     * @param regionname
     * @param operUser
     * @return
     */
    @RequestMapping("/loadRegionList")
    @ResponseBody
    public Map loadRegionList(HttpServletRequest request,
                               HttpServletResponse response,
                               @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                               @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                               @RequestParam(value = "regionname", required = false, defaultValue = "") String regionname,
                               @AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try{
            String opertype = operUser.getOpertype();
            Pagination page = null;
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                page = systemService.getSystemRegionList(regionname, pageNo, pageSize);
            }else {
                page = systemService.getOperatorRegionList(regionname, operUser.getRegionid(), pageNo, pageSize);
            }
            map.put("PageResult", page);
        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }


    /**
     * 删除区域
     * @param regionid
     * @param request
     * @param response
     * @return
     */
    @RequestMapping("/deleteRegion")
    @ResponseBody
    public Map deleteRegion(@RequestParam(value = "regionid") String regionid,
                            HttpServletRequest request, HttpServletResponse response){
        //TODO 返回无权限删除此区域
        Map map = new HashMap();
        String message="";
        try{
            List<TBuilding> building = systemService.getBuildingByRegionId(regionid);
            List<TRegion> regionByParentId = systemService.getRegionByParentId(regionid);
            if (building!=null && regionByParentId!=null){
                message="此区域已被绑定!";
                map.put("message", message);
                return map;
            }
            boolean flag = systemService.deleteRegionById(regionid);
            if (flag==false){
                message="删除区域失败!";
            }

        }catch (Exception e){
            e.printStackTrace();
            message="删除区域出错!";
        }
        map.put("message", message);
        return map;
    }

    /**
     * 获取指定区域信息
     * @param regionid
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping("/loadRegionForUpdate")
    public Map loadRegionForUpdate(@RequestParam(value = "regionid") String regionid,
                                   @AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try {
            TRegion region = systemService.getRegionById(regionid);
            map.put("region",region);
            List<TDictionaryId> dicts = systemService.findTDictionaryByType(6);//区域级别
            map.put("dicts", dicts);
            if (region!=null) {
                List<TRegion> fRegion = systemService.getRegionListByLevel(region.getLevel());
                map.put("fRegion", fRegion);
            }else {
                List<TRegion> fRegion = systemService.getAllRegions();
                map.put("fRegion", fRegion);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 保存区域
     * @param postData
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/addRegion", method = {RequestMethod.POST})
    public Map addRegion (@RequestBody RegionBean postData){
        Map map = new HashMap();
        try{
            TRegion regionById = systemService.getRegionById(postData.getRegionid());
            if (regionById!=null){
                map.put("errStr", "区域编号已经存在，请修改！");
                return map;
            }
            TRegion regionByName = systemService.getRegionByName(postData.getRegionname());
            if (regionByName!=null){
                map.put("errStr", "区域名称已经存在，请修改！");
                return map;
            }
            TRegion region= new TRegion();
            region.setRegionid(postData.getRegionid());
            region.setAddress(postData.getAddress());
            region.setLevel(postData.getLevel());
            region.setParentid(postData.getParentid());
            region.setRegionname(postData.getRegionname());
            region.setRemarks(postData.getRemarks());
            TRegion tRegion = systemService.getRegionById(postData.getParentid());
            region.setParentname(tRegion.getRegionname());
            region.setFlag(1);

            systemService.saveRegion(region);
            map.put("errStr", "");
        }catch (Exception e){
            e.printStackTrace();
            map.put("errStr", "保存区域失败!");
        }
        return map;
    }

    /**
     * 修改区域
     * @param postData
     * @return
     */
    @RequestMapping(value = "/updateRegion", method = {RequestMethod.POST})
    @ResponseBody
    public Map updateRegion(@RequestBody RegionBean postData){
        Map map = new HashMap();
        try {
            if (postData == null) {
                map.put("errStr", "请先选择区域，然后再修改！");
                return map;
            }
            TRegion regionByName = systemService.getRegionByNameAndId(postData.getRegionname(), postData.getRegionid());
            if (regionByName!=null){
                map.put("errStr", "区域名称已经存在，请修改！");
                return map;
            }
            TRegion region = systemService.getRegionById(postData.getRegionid());
            region.setAddress(postData.getAddress());
            region.setLevel(postData.getLevel());
            region.setParentid(postData.getParentid());
            region.setRegionname(postData.getRegionname());
            region.setRemarks(postData.getRemarks());
            TRegion tRegion = systemService.getRegionById(postData.getParentid());
            region.setParentname(tRegion.getParentname());
            region.setFlag(1);

            systemService.updateRegion(region);
            map.put("errStr", "");
        }catch (Exception e){
            e.printStackTrace();
            map.put("errStr", "区域修改失败!");
        }
        return map;
    }

    /**
     * 获取选取区域等级的所有可选父区域
     * @param level
     * @return
     */
    @ResponseBody
    @RequestMapping("/getFregion")
    public Map getFregion(@RequestParam(value = "level")int level){
        Map map = new HashMap();
        try{
            List<TRegion> parentRegion = systemService.getRegionListByLevel(level);
            map.put("parentRegion", parentRegion);
        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 根据查询条件分页获取楼栋
     * @param request
     * @param response
     * @param pageNo
     * @param pageSize
     * @param regionid
     * @param buildingname
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping("/loadBuildingList")
    public Map loadBuildingList(HttpServletRequest request,
                                HttpServletResponse response,
                                @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                                @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                                @RequestParam(value = "regionid", required = false, defaultValue = "") String regionid,
                                @RequestParam(value = "buildingname",required = false,defaultValue = "")String buildingname,
                                @AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try {
            String opertype = operUser.getOpertype();
            Pagination page = null;


            List<TRegion> regionList = null;
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                regionList = systemService.getAllRegions();
                page = systemService.getSystemBuildingList(regionid, buildingname, pageNo, pageSize);
                map.put("pageResult", page);
            }else if (!StringUtil.isEmpty(operUser.getRegionid())){
                regionList = systemService.getRegionListById(operUser.getRegionid());
                page = systemService.getSystemBuildingList(operUser.getRegionid(), buildingname, pageNo, pageSize);//regionid固定为管理员的权限区域id
                map.put("pageResult", page);

            }
            map.put("regionList", regionList);

        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 根据楼栋id获取楼栋信息填充
     * @param buildingid
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/loadBuildingForUpdate" )
    public Map loadBuildingForUpdate(@RequestParam(value = "buildingid") String buildingid,
                                     @AuthenticationPrincipal TOperator operUser){
        Map map = new HashMap();
        try{
            String opertype = operUser.getOpertype();
            TBuilding building = systemService.getBuildingById(buildingid);
            map.put("building", building);
            List<TRegion> regionList = null;
            if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                regionList = systemService.getAllRegions();
            }else if (!StringUtil.isEmpty(operUser.getRegionid())){
                regionList = systemService.getRegionListById(operUser.getRegionid());
            }
            map.put("regionslist", regionList);

        }catch (Exception e){
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 保存楼栋
     * @param postData
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/addBuilding",method = RequestMethod.POST)
    public Map addBuilding(@RequestBody BuildingBean postData){
        Map map = new HashMap();
        try {
            TBuilding buildingById = systemService.getBuildingById(postData.getBuildingid());
            if (buildingById!=null){
                map.put("errStr", "楼栋编号已经存在，请修改！");
                return map;
            }
            TBuilding buildingByName = systemService.getBuildingByName(postData.getBuildingname());
            if (buildingByName!=null){
                map.put("errStr", "楼栋名称已经存在，请修改！");
                return map;
            }
            String now = DateUtil.getNow();
            TBuilding tBuilding = new TBuilding();
            tBuilding.setBuildingid(postData.getBuildingid());
            tBuilding.setBuildingname(postData.getBuildingname());
            tBuilding.setBuildingdesc(postData.getBuildingdesc());
            tBuilding.setRegionid(postData.getRegionid());
            tBuilding.setSynctime(now);
            tBuilding.setUpdtime(now);
            tBuilding.setFlag("A");

            systemService.saveBuilding(tBuilding);
            map.put("errStr", "");
        }catch (Exception e){
            e.printStackTrace();
            map.put("errStr", "保存楼栋失败");
        }
        return map;
    }

    /**
     * 修改楼栋
     * @param postData
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/updateBuilding",method = RequestMethod.POST)
    public Map updateBuilding(@RequestBody BuildingBean postData){
        Map map = new HashMap();
        try{
            if (postData==null){
                map.put("errStr", "请先选择楼栋再修改!");
            }
            TBuilding buildingByNameAndId = systemService.getBuildingByNameAndId(postData.getBuildingname(), postData.getBuildingid());
            if (buildingByNameAndId!=null){
                map.put("errStr", "楼栋名称已经存在，请修改！");
                return map;
            }
            String now = DateUtil.getNow();
            TBuilding building = systemService.getBuildingById(postData.getBuildingid());
            building.setBuildingname(postData.getBuildingname());
            building.setBuildingdesc(postData.getBuildingdesc());
            building.setRegionid(postData.getRegionid());
            building.setSynctime(now);
            building.setUpdtime(now);
            building.setFlag("A");

            systemService.updateBuilding(building);
            map.put("errStr", "");
        }catch (Exception e){
            e.printStackTrace();
            map.put("errStr", "楼栋修改失败");
        }
        return map;
    }

    /**
     * 删除楼栋
     * @param buildingid
     * @return
     */
    @ResponseBody
    @RequestMapping("/deleteBuilding")
    public Map deleteBuilding(@RequestParam(value = "buildingid") String buildingid){
        Map map = new HashMap();
        String message="";
        try{
            TNcDevice devByBuildingid = ncService.getDevByBuildingid(buildingid);
            if (devByBuildingid!=null){
                message="该楼栋已被绑定!";
                map.put("message", message);
                return map;
            }
            boolean b = systemService.delBuilding(buildingid);
            if (b==false){
                message="删除楼栋失败!";
            }

        }catch (Exception e){
            e.printStackTrace();
            message="删除楼栋错误";
        }
        map.put("message", message);
        return map;
    }

    /**
     * 获取分配楼栋填充数据
     * @param operid
     * @param operUser
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/getBuildingList")
    public Map getBuildingList(@RequestParam(value = "operid", required = true) String operid,
                               @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        int flag = 0;
        try {
            String opertype = operUser.getOpertype();
            List<AllotBuildingBean> buildinglist = null;
            List<AllotBuildingBean> buildinglisted = null;
            if(opertype.equals("L")){
                flag = 1;
                map.put("result", "没有分配楼栋权限!");
            }else if (!StringUtil.isEmpty(opertype) &&(opertype.equals("S")||opertype.equals("P"))){
                buildinglist = systemService.findSystemAllotBuildingList();
                buildinglisted = systemService.findBuildingInOper(operid);
                map.put("result", "楼栋信息查询完成");
            }else if (!StringUtil.isEmpty(operUser.getRegionid())){
                buildinglist = systemService.findOperatorAllotBuildingList(operUser.getRegionid());
                buildinglisted = systemService.findBuildingInOper(operid);
                map.put("result", "楼栋信息查询完成");
            }
            map.put("buildinglist", buildinglist);//  待选楼栋
            map.put("buildinglisted", buildinglisted);//  已选楼栋

            map.put("flag", flag);
        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "楼栋信息查询失败");
            logger.error("楼栋信息查询失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 保存操作员楼栋
     * @param operid
     * @param buildingArry
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/saveOperBuildingBind", method = {RequestMethod.POST})
    public Map saveOperBuildingBind(@RequestParam(value = "operid", required = true) String operid,
                                    @RequestBody String[] buildingArry,
                                    @AuthenticationPrincipal TOperator operUser) {
        Map map = new HashMap();
        int okFlag = 0;
        try {
            if (buildingArry != null && buildingArry.length > 0) {
                systemService.deleteOperBuildingByOperid(operid);
                TOperbuilding operbuilding = null;
                TOperbuildingId id = null;
                for (String bean : buildingArry) {
                    String[] buildings = bean.split("#");
                    operbuilding = new TOperbuilding();
                    id = new TOperbuildingId();
                    id.setOperid(operid);
                    id.setBuildingid(buildings[1]);
                    operbuilding.setId(id);
                    operbuilding.setMemo("");
                    operbuilding.setAllotoperid(operUser.getOperid());
                    operbuilding.setUpdtime(DateUtil.getNow());
                    systemService.saveOperBuilding(operbuilding);
                }
                map.put("result", "管理员：" + operid + "，分配楼栋成功");
            }
            okFlag = 1;
        } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "管理员：" + operid + "，分配楼栋失败");
            logger.error("分配设备失败：" + e.getMessage());
        }
        map.put("okFlag", okFlag);
        return map;
    }
}
