package com.supwisdom.dlpay.system.dao.impl;

import com.supwisdom.dlpay.system.dao.DictionaryDao;
import com.supwisdom.dlpay.system.domain.DictionaryType;
import com.supwisdom.dlpay.system.domain.TDictionary;
import com.supwisdom.dlpay.system.domain.TDictionaryId;
import com.supwisdom.dlpay.system.page.Pagination;
import org.hibernate.transform.Transformers;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;

@Repository
public class DictionaryDaoImpl implements DictionaryDao {

    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    @Override
    public Pagination findDictionary(String dicttype, String dictcaption, int pageNo, int pageSize) {
        String sql="SELECT t.dicttype,t.dicttypename,t.dictval,"
                + "t.dictcaption FROM t_dictionary t"
                + " WHERE 1=1 ";
        if(!dicttype.equals("all")){
            sql+="and t.dicttype=:dicttype ";
        }
        if(!dictcaption.equals("")){
            sql+="and  t.dictcaption like :dictcaption ";
        }
        sql+="order by t.dicttype";
        Query query = entityManager.createNativeQuery(sql,TDictionary.class);

        if(!dicttype.equals("all")){
            query.setParameter("dicttype", Integer.parseInt(dicttype));
        }
        if(!dictcaption.equals("")){
            query.setParameter("dictcaption", "%"+dictcaption+"%");
        }

        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TDictionary> list = query.getResultList();
        page.setList(list);
        int totalCount = findDictionaryCount(dicttype, dictcaption);
        page.setTotalCount(totalCount);
        return page;
    }

    private int findDictionaryCount(String dicttype, String dictcaption){
        String sql = "select count(*) from t_dictionary where 1>0 ";
        if(!dicttype.equals("all")){
            sql+="and dicttype=:dicttype ";
        }
        if(!dictcaption.equals("")){
            sql+="and  dictcaption like :dictcaption ";
        }
        Query query = entityManager.createNativeQuery(sql);
        if(!dicttype.equals("all")){
            query.setParameter("dicttype", Integer.parseInt(dicttype));
        }
        if(!dictcaption.equals("")){
            query.setParameter("dictcaption", "%"+dictcaption+"%");
        }
        int cnt = 0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public List<DictionaryType> findDictionaryType() {
        try {
            String jpql = "Select distinct(t.dicttype),t.dicttypename,t.dictval,t.dictcaption From t_dictionary  t";
            Query query = entityManager.createNativeQuery(jpql,TDictionary.class);
            List<TDictionary> list = query.getResultList();
            List<DictionaryType> type = new ArrayList<>();
            for (TDictionary bean:list){
                DictionaryType tmpBean = new DictionaryType();
                tmpBean.setDicttype(bean.getId().getDicttype()+"");
                tmpBean.setDicttypename(bean.getId().getDicttypename());
                type.add(tmpBean);
            }
            return type;
        }catch (Exception e){
            e.printStackTrace();

        }

        return null;
    }

    @Transactional
    @Override
    public boolean saveDictionary(TDictionary dictionary) {
        boolean flag=false;
        try {
            entityManager.persist(dictionary);
            flag=true;
        }catch (Exception e){
            throw e;
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TDictionaryId> findTDictionaryByType(int type) {
        String sql = "select bean.id from TDictionary bean where bean.id.dicttype=?1";
        Query query = entityManager.createQuery(sql,TDictionaryId.class);
        query.setParameter(1, type);
        List list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public List<TDictionaryId> findOpertypes(String opertype) {
        String sql = "select bean.id from TDictionary bean where bean.id.dicttype=1";
        if (opertype.equals("P")){
            sql +=" and bean.id.dictval<>'P'";
        }else if (opertype.equals("S")){
            sql +=" and bean.id.dictval<>'P' and bean.id.dictval<>'S'";
        }else if (opertype.equals("H")){
            sql +=" and bean.id.dictval<>'P' and bean.id.dictval<>'S' and bean.id.dictval<>'H'";
        }else {
            return null;
        }
        TypedQuery<TDictionaryId> query = entityManager.createQuery(sql, TDictionaryId.class);
        List<TDictionaryId> list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public List<TDictionaryId> findByType(int type, String dicVal) {
        String sql = "select bean.id from TDictionary bean where bean.id.dicttype=?1 and bean.id.dictval = ?2";
        Query query = entityManager.createQuery(sql,TDictionaryId.class);
        query.setParameter(1, type);
        query.setParameter(2, dicVal);
        List list = query.getResultList();
        return list;
    }

    @Transactional
    @Override
    public TDictionary updateDictionary(String dicttype, String dicttypename, String dictval, String dictcaption, String oriengaltype, String oriengalval) {
        String sql="update t_dictionary set dicttype = ?1,dicttypename=?2,dictval=?3,dictcaption=?4 "
                + "where dicttype=?5 and dictval=?6";
        Query queryObject = entityManager.createNativeQuery(sql);
        queryObject.setParameter(1, Integer.parseInt(dicttype));
        queryObject.setParameter(2, dicttypename);
        queryObject.setParameter(3, dictval);
        queryObject.setParameter(4, dictcaption);
        queryObject.setParameter(5, Integer.parseInt(oriengaltype));
        queryObject.setParameter(6, oriengalval);
        queryObject.executeUpdate();
        return null;
    }
}
