package com.supwisdom.dlpay.system.dao.impl;

import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.dao.RegionDao;
import com.supwisdom.dlpay.system.domain.TRegion;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class RegionDaoImpl implements RegionDao {

    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getSystemRegionList(String regionname, int pageNo, int pageSize) {
        String sql = "select bean from TRegion bean where 1>0 and bean.flag=1 ";
        if (!StringUtil.isEmpty(regionname)){
            sql += " and bean.regionname like :regionname ";
        }

        sql += " order by bean.level";

        TypedQuery<TRegion> query = entityManager.createQuery(sql, TRegion.class);
        if(!StringUtil.isEmpty(regionname)){
            query.setParameter("regionname", "%"+regionname+"%" );
        }
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TRegion> list = query.getResultList();
        page.setList(list);
        int totalCount = getSystemRegionListCount(regionname);
        page.setTotalCount(totalCount);
        return page;
    }

    private int getSystemRegionListCount(String regionname){
        String sql = "select count(*) from TB_Region where 1>0 and flag=1 ";
        if (!StringUtil.isEmpty(regionname)){
            sql += " and regionname like :regionname ";
        }
        Query query = entityManager.createNativeQuery(sql);
        if(!StringUtil.isEmpty(regionname)){
            query.setParameter("regionname", "%"+regionname+"%" );
        }
        int cnt=0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return cnt;
    }

    @Transactional
    @Override
    public Pagination getOperatorRegionList(String regionname, String regionid, int pageNo, int pageSize) {
        String sql = "select bean.regionid,bean.address,bean.level,bean.parentid,bean.regionname,bean.remarks,bean.parentname,bean.flag" +
                " from Tb_Region bean where 1>0 and bean.flag=1 ";
        sql += "and bean.regionid in  " +
                "(with recursive tmp as  (select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  " +
                " ) select regionid from tmp  ";

        if (!StringUtil.isEmpty(regionname)){
            sql += " and tmp.regionname like :regionname ";
        }
        sql += ") order by bean.level";

        Query query = entityManager.createNativeQuery(sql, TRegion.class);
        query.setParameter("regionid" , regionid);
        if(!StringUtil.isEmpty(regionname)){
            query.setParameter("regionname", "%"+regionname+"%" );
        }

        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        List<TRegion> list = query.getResultList();
        page.setList(list);
        int totalCount = getOperatorRegionListCount(regionname,regionid);
        page.setTotalCount(totalCount);
        return page;
    }


    private int getOperatorRegionListCount(String regionname,String regionid){
        String sql = "select count(*) from Tb_Region bean where 1>0 and bean.flag=1 ";
        sql += "and bean.regionid in  " +
                "(with recursive tmp as  (select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  " +
                " ) select regionid from tmp  ";

        if (!StringUtil.isEmpty(regionname)){
            sql += " and tmp.regionname like :regionname";
        }
        sql += ") ";
        Query query = entityManager.createNativeQuery(sql);
        query.setParameter("regionid" , regionid);
        if(!StringUtil.isEmpty(regionname)){
            query.setParameter("regionname", "%"+regionname+"%" );
        }
        int cnt = 0;
        List list = query.getResultList();
        if (list!=null && list.size()>0){
            cnt = Integer.parseInt(list.get(0).toString());
        }
        return  cnt ;
    }

    @Transactional
    @Override
    public boolean updateRegionFlag(String regionid) {
        boolean flag = false;
        try {
            String sql = "update tb_region set flag = 0 where regionid = ?1 ";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter(1, regionid);
            query.executeUpdate();
            flag = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TRegion getRegionById(String regionid) {
        String sql = "select bean from TRegion bean where bean.regionid = :regionid and bean.flag=1 ";
        TypedQuery<TRegion> query = entityManager.createQuery(sql, TRegion.class);
        query.setParameter("regionid", regionid );
        List<TRegion> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public List<TRegion> getRegionListById(String regionid) {
        String sql = "select bean.regionid,bean.address,bean.level,bean.parentid,bean.regionname,bean.remarks,bean.parentname,bean.flag " +
                "from TB_REGION bean where flag=1 "+
                "and bean.regionid in  " +
                "(with recursive tmp as  (select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr " +
                " where regionid= :regionid union all  select tbr.regionid,tbr.parentid,tbr.regionname from tb_region tbr inner join tmp t on t.regionid=tbr.parentid  " +
                " ) select regionid from tmp  )";
        Query query = entityManager.createNativeQuery(sql, TRegion.class);
        query.setParameter("regionid", regionid);
        List list = query.getResultList();

        return list;
    }

    @Transactional
    @Override
    public List<TRegion> getRegionListByLevel(int level) {
        String sql = "select bean from TRegion bean where bean.flag=1 and bean.level=:level";
        TypedQuery<TRegion> query = entityManager.createQuery(sql, TRegion.class);
        query.setParameter("level" , level-1);
        List<TRegion> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list;
        }
        return null;
    }

    @Transactional
    @Override
    public List<TRegion> getAllRegions() {
        String sql = "select bean from TRegion bean where bean.flag = 1";
        TypedQuery<TRegion> query = entityManager.createQuery(sql, TRegion.class);
        List<TRegion> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list;
        }
        return null;
    }

    @Transactional
    @Override
    public TRegion getRegionByName(String regionname) {
        String sql = "select bean from TRegion bean where bean.regionname = :regionname and bean.flag=1 ";
        TypedQuery<TRegion> query = entityManager.createQuery(sql, TRegion.class);
        query.setParameter("regionname", regionname );
        List<TRegion> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean saveRegion(TRegion bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TRegion getRegionByNameAndId(String regionname, String regionid) {
        String sql = "select bean from TRegion bean where bean.regionname = :regionname and bean.flag=1 and bean.regionid <>:regionid";
        TypedQuery<TRegion> query = entityManager.createQuery(sql, TRegion.class);
        query.setParameter("regionname", regionname );
        query.setParameter("regionid",  regionid);
        List<TRegion> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateRegion(TRegion bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TRegion> getRegionByParentId(String parentid) {
        String sql = "select bean from TRegion bean where bean.flag=1 and bean.parentid=:parentid";
        TypedQuery<TRegion> query = entityManager.createQuery(sql, TRegion.class);
        query.setParameter("parentid", parentid);
        List<TRegion> list = query.getResultList();
        return list;
    }

}
