package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.framework.domain.TOperRole;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.domain.TRole;
import com.supwisdom.dlpay.system.page.Pagination;

public interface ManagerService {

    //分页获取所有操作员列表
    Pagination getOperatorList(String operid, String realname, int pageNo, int pageSize);

    //根据id删除操作员 -- 实际修改状态status为close
    boolean deleteOperatorById(String operid);

    //根据id获取对应管理员
    TOperator getOperatorById(String operid);

    //根据管理员id获取其对应角色
    TRole getOperRoleById(String operid);

    //保存管理员
    boolean saveOperator(TOperator bean);

    //修改操作员
    boolean updateOperator(TOperator bean);

    //保存管理员角色
    boolean saveOperRole(TOperRole bean);

    //根据操作员id获取TOperRole
    TOperRole getTOperRoleByOperid(String operid);

    //修改ToperRole
    boolean updateTOperRole(TOperRole bean);
}
