package com.supwisdom.dlpay.system.service;


import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.system.bean.AllotBuildingBean;
import com.supwisdom.dlpay.system.domain.*;
import com.supwisdom.dlpay.system.page.Pagination;

import java.util.List;

public interface SystemService {

    //根据查询条件分页查询字典
    public Pagination findDictionary(String dicttype, String dictcaption, Integer pageNo, Integer pageSize);

    //获取所有字典类型
    public List<DictionaryType> findDictionaryType();

    //保存字典值
    public boolean saveDictionary(String dicttype, String dicttypename, String dictval, String dictcaption);

    //根据类型获取字典值
    public List<TDictionaryId> findTDictionaryByType(int type);

    //根据管理员属性获取其能分配的管理员属性 sql中字典type固定为1
    public List<TDictionaryId> findOpertypes(String opertype);

    //根据类型和值获取字典值
    public List<TDictionaryId> findByType(int type, String dicVal);

    //修改字典值
    public TDictionary updateDictionary(String dicttype, String dicttypename, String dictval, String dictcaption, String oriengaltype, String oriengalval);


    //根据查询条件分页获取所有区域
    public Pagination getSystemRegionList(String regionname,int pageNo,int pageSize);

    //根据查询条件以及管理员区域分页获取区域
    public Pagination getOperatorRegionList(String regionname,String regionid,int pageNo,int pageSize);

    //根据区域id查询楼栋
    public List<TBuilding> getBuildingByRegionId(String regionid);

    //根据id删除区域--修改状态flag为0
    public boolean deleteRegionById(String regionid);

    //根据id获取区域
    public TRegion getRegionById(String regionid);

    //根据区域id获取其权限下所有区域
    public List<TRegion> getRegionListById(String regionid);

    //根据区域级别获取其上一级级别的所有区域
    public List<TRegion> getRegionListByLevel(int level);

    //获取所有区域
    public List<TRegion> getAllRegions();

    //根据名称获取区域
    public TRegion getRegionByName(String regionname);

    //保存区域
    public boolean saveRegion(TRegion bean);

    //根据id和名称获取非本id的相同名称区域
    public TRegion getRegionByNameAndId(String regionname,String regionid);

    //修改区域
    public boolean updateRegion(TRegion bean);

    //根据parentid获取区域
    public List<TRegion> getRegionByParentId(String parentid);

    //根据查询条件分页获取所有楼栋
    public Pagination getSystemBuildingList(String regionid,String buildingname,int pageNo,int pageSize);

    //根据id获取楼栋信息
    public TBuilding getBuildingById(String buildingid);

    //根据名称获取楼栋信息
    public TBuilding getBuildingByName(String buildingname);

    //保存楼栋
    public boolean saveBuilding(TBuilding bean);

    //根据id和名称获取非本id的相同名称楼栋
    public TBuilding getBuildingByNameAndId(String buildingname,String buildingid);

    //修改楼栋
    public boolean updateBuilding(TBuilding bean);

    //根据id删除楼栋---修改flag为D
    public boolean delBuilding(String buildingid);

    //获取所有要分配的楼栋
    public List<AllotBuildingBean> findSystemAllotBuildingList();

    //获取操作员权限下要分配的楼栋
    public List<AllotBuildingBean> findOperatorAllotBuildingList(String operRegionid);

    //获取已经分配过的楼栋
    public List<AllotBuildingBean> findBuildingInOper(String operid);

    //根据操作员id删除所有分配的楼栋
    public boolean deleteOperBuildingByOperid(String operid);

    //保存操作员分配的楼栋
    public boolean saveOperBuilding(TOperbuilding bean);
}
