package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.ncmgr.domain.TBuilding;
import com.supwisdom.dlpay.system.bean.AllotBuildingBean;
import com.supwisdom.dlpay.system.dao.BuildingDao;
import com.supwisdom.dlpay.system.dao.DictionaryDao;
import com.supwisdom.dlpay.system.dao.OperatorDao;
import com.supwisdom.dlpay.system.dao.RegionDao;
import com.supwisdom.dlpay.system.domain.*;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SystemServiceImpl implements SystemService {
    @Autowired
    private DictionaryDao dictionaryDao;
    @Autowired
    private OperatorDao operatorDao;
    @Autowired
    private RegionDao regionDao;
    @Autowired
    private BuildingDao buildingDao;

    @Override
    public Pagination findDictionary(String dicttype, String dictcaption, Integer pageNo, Integer pageSize) {
        return dictionaryDao.findDictionary(dicttype, dictcaption, pageNo, pageSize);
    }

    @Override
    public List<DictionaryType> findDictionaryType() {
        return dictionaryDao.findDictionaryType();
    }

    @Override
    public boolean saveDictionary(String dicttype, String dicttypename, String dictval, String dictcaption) {
        TDictionary tDictionary = new TDictionary();
        TDictionaryId tDictionaryId = new TDictionaryId();
        tDictionaryId.setDicttype(Integer.parseInt(dicttype));
        tDictionaryId.setDicttypename(dicttypename);
        tDictionaryId.setDictval(dictval);
        tDictionaryId.setDictcaption(dictcaption);
        tDictionary.setId(tDictionaryId);
        boolean b = dictionaryDao.saveDictionary(tDictionary);
        return b;
    }

    @Override
    public List<TDictionaryId> findTDictionaryByType(int type) {
        return dictionaryDao.findTDictionaryByType(type);
    }

    @Override
    public List<TDictionaryId> findOpertypes(String opertype) {
        return dictionaryDao.findOpertypes(opertype);
    }

    @Override
    public List<TDictionaryId> findByType(int type, String dicVal) {
        return dictionaryDao.findByType(type, dicVal);
    }

    @Override
    public TDictionary updateDictionary(String dicttype, String dicttypename, String dictval, String dictcaption, String oriengaltype, String oriengalval) {
        return dictionaryDao.updateDictionary(dicttype, dicttypename, dictval, dictcaption, oriengaltype, oriengalval);
    }


    @Override
    public Pagination getSystemRegionList(String regionname, int pageNo, int pageSize) {
        return regionDao.getSystemRegionList(regionname, pageNo, pageSize);
    }

    @Override
    public Pagination getOperatorRegionList(String regionname, String regionid, int pageNo, int pageSize) {
        return regionDao.getOperatorRegionList(regionname, regionid, pageNo, pageSize);
    }

    @Override
    public List<TBuilding> getBuildingByRegionId(String regionid) {
        return buildingDao.getBuildingByRegionId(regionid);
    }

    @Override
    public boolean deleteRegionById(String regionid) {
        return regionDao.updateRegionFlag(regionid);
    }

    @Override
    public TRegion getRegionById(String regionid) {
        return regionDao.getRegionById(regionid);
    }

    @Override
    public List<TRegion> getRegionListById(String regionid) {
        return regionDao.getRegionListById(regionid);
    }

    @Override
    public List<TRegion> getRegionListByLevel(int level) {
        return regionDao.getRegionListByLevel(level);
    }

    @Override
    public List<TRegion> getAllRegions() {
        return regionDao.getAllRegions();
    }

    @Override
    public TRegion getRegionByName(String regionname) {
        return regionDao.getRegionByName(regionname);
    }

    @Override
    public boolean saveRegion(TRegion bean) {
        return regionDao.saveRegion(bean);
    }

    @Override
    public TRegion getRegionByNameAndId(String regionname, String regionid) {
        return regionDao.getRegionByNameAndId(regionname, regionid);
    }

    @Override
    public boolean updateRegion(TRegion bean) {
        return regionDao.updateRegion(bean);
    }

    @Override
    public List<TRegion> getRegionByParentId(String parentid) {
        return regionDao.getRegionByParentId(parentid);
    }

    @Override
    public Pagination getSystemBuildingList(String regionid, String buildingname, int pageNo, int pageSize) {
        return buildingDao.getSystemBuildingList(regionid, buildingname, pageNo, pageSize);
    }

    @Override
    public TBuilding getBuildingById(String buildingid) {
        return buildingDao.getBuildingById(buildingid);
    }

    @Override
    public TBuilding getBuildingByName(String buildingname) {
        return buildingDao.getBuildingByName(buildingname);
    }

    @Override
    public boolean saveBuilding(TBuilding bean) {
        return buildingDao.saveBuilding(bean);
    }

    @Override
    public TBuilding getBuildingByNameAndId(String buildingname, String buildingid) {
        return buildingDao.getBuildingByNameAndId(buildingname, buildingid);
    }

    @Override
    public boolean updateBuilding(TBuilding bean) {
        return buildingDao.updateBuilding(bean);
    }

    @Override
    public boolean delBuilding(String buildingid) {
        return buildingDao.updateBuildingFlag(buildingid);
    }

    @Override
    public List<AllotBuildingBean> findSystemAllotBuildingList() {
        return buildingDao.findSystemAllotBuildingList();
    }

    @Override
    public List<AllotBuildingBean> findOperatorAllotBuildingList(String operRegionid) {
        return buildingDao.findOperatorAllotBuildingList(operRegionid);
    }

    @Override
    public List<AllotBuildingBean> findBuildingInOper(String operid) {
        return buildingDao.findBuildingInOper(operid);
    }

    @Override
    public boolean deleteOperBuildingByOperid(String operid) {
        return buildingDao.deleteOperBuildingByOperid(operid);
    }

    @Override
    public boolean saveOperBuilding(TOperbuilding bean) {
        return buildingDao.saveOperBuilding(bean);
    }

}
