package com.supwisdom.dlpay.api.dao;

import com.supwisdom.dlpay.api.domain.TDebitCreditDtl;
import com.supwisdom.dlpay.api.domain.TDebitCreditDtlPK;
import com.supwisdom.dlpay.framework.data.VoucherTemp;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface DebitCreditDtlDao extends JpaRepository<TDebitCreditDtl, TDebitCreditDtlPK> {

  @Query(value = "select a.drsubjno,case when a.drsubjno='220201' then '220201' else a.draccno end as draccno, a.crsubjno,case when a.crsubjno='220201' then '220201' else a.craccno end as craccno," +
      "a.summary,count(distinct a.refno) as transcnt,sum(a.amount) as transamt " +
      "from TB_USERDTL_DEBITCREDIT a left join TB_TRANSACTIONMAIN b on a.refno=b.refno " +
      "where b.status='success' and b.accdate=:settledate " +
      "group by a.drsubjno,case when a.drsubjno='220201' then '220201' else a.draccno end,a.crsubjno,case when a.crsubjno='220201' then '220201' else a.craccno end,a.summary ", nativeQuery = true)
  List<VoucherTemp> getVoucherData(@Param("settledate") String settledate);

  List<TDebitCreditDtl> findByRefno(String refno);
}
