package com.supwisdom.dlpay.api.dao;

import com.supwisdom.dlpay.api.domain.TTransactionMain;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.CrudRepository;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;

public interface TransactionMainDao extends CrudRepository<TTransactionMain, String> {

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
  @Query(value = "select t from TTransactionMain t where t.refno = ?1")
  TTransactionMain findByRefnoForUpdate(String refno);
}
