package com.supwisdom.dlpay.api.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Entity
@Table(name = "TB_SHOP_PAYTYPE_CONFIG", indexes = {@Index(name = "shop_paytype_config_uk", unique = true, columnList = "shopaccno,paytype,configid")})
public class TShopPaytypeConfig {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "CFGID", nullable = false, length = 32)
  private String cfgid;

  @Column(name = "SHOPACCNO", nullable = false, length = 10)
  private String shopaccno;

  @Column(name = "PAYTYPE", nullable = false, length = 20)
  private String paytype;

  @Column(name = "CONFIGID", nullable = false, length = 40)
  private String configid;

  @Column(name = "CONFIG_VALUE", length = 2000)
  private String configValue;

  @Column(name = "CONFIG_NAME", length = 200)
  private String configName;

  public TShopPaytypeConfig() {
  }

  public TShopPaytypeConfig(String shopaccno, String paytype, String configid, String configValue, String configName) {
    this.shopaccno = shopaccno;
    this.paytype = paytype;
    this.configid = configid;
    this.configValue = configValue;
    this.configName = configName;
  }

  public String getCfgid() {
    return cfgid;
  }

  public void setCfgid(String cfgid) {
    this.cfgid = cfgid;
  }

  public String getShopaccno() {
    return shopaccno;
  }

  public void setShopaccno(String shopaccno) {
    this.shopaccno = shopaccno;
  }

  public String getPaytype() {
    return paytype;
  }

  public void setPaytype(String paytype) {
    this.paytype = paytype;
  }

  public String getConfigid() {
    return configid;
  }

  public void setConfigid(String configid) {
    this.configid = configid;
  }

  public String getConfigValue() {
    return configValue;
  }

  public void setConfigValue(String configValue) {
    this.configValue = configValue;
  }

  public String getConfigName() {
    return configName;
  }

  public void setConfigName(String configName) {
    this.configName = configName;
  }
}
