package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;

import java.sql.Timestamp;
import java.util.List;

import static javax.persistence.FetchType.LAZY;

@Entity
@Table(name = "TB_TRANSACTIONMAIN",
    indexes = {@Index(name = "transmain_accdate", columnList = "accdate"),
        @Index(name = "transmain_status", columnList = "status"),
        @Index(name = "transmain_outtrade", unique = true, columnList = "outid, outtradeno")})
public class TTransactionMain {
  @Id
  @Column(name = "refno", nullable = false, length = 32)
  private String refno;

  @Column(name = "accdate", nullable = false, length = 8)
  private String accdate;

  @Column(name = "checkable")
  private Boolean checkable; // 是否需要清算的交易

  @Column(name = "checkdate", length = 8)
  private String checkDate;

  @Column(name = "person")
  private Boolean person = false;

  @Column(name = "shop")
  private Boolean shop = false;

  @Column(name = "subject")
  private Boolean subject = false;

  @Column(name = "status", length = 20)
  private String status = "none";

  @Column(name = "sourcetype", length = 20)
  private String sourceType = "";

  @Column(name = "outtradeno", length = 60)
  private String outTradeNo = "";

  @Column(name = "outid", length = 60)
  private String outId;

  @Column(name = "OPERID", precision = 9)
  private String operid; //操作员ID

  @Column(name = "OPERTYPE", length = 10)
  private String opertype; // person - 个人， shop - 商户， operator - 操作员

  @Column(name = "settledate", length = 8)
  private String settleDate;

  @Column(name = "create_time")
  private Timestamp createTime;

  @Column(name = "end_time")
  private Timestamp endTime;

  @Column(name = "reverse_flag", nullable = false, length = 10)
  private String reverseFlag = "none"; // 冲正标识， none - 未冲正, reverse - 被撤销, cancel - 被冲正

  @OneToOne(targetEntity = TPersondtl.class, fetch = LAZY, cascade = CascadeType.ALL)
  @JoinColumn(name = "refno", referencedColumnName = "refno")
  private TPersondtl personDtl;

  @OneToOne(targetEntity = TShopdtl.class, fetch = LAZY, cascade = CascadeType.ALL)
  @JoinColumn(name = "refno", referencedColumnName = "refno")
  private TShopdtl shopDtl;

  @OneToOne(targetEntity = TSubjectdtl.class, fetch = LAZY, cascade = CascadeType.ALL)
  @JoinColumn(name = "refno", referencedColumnName = "refno")
  private TSubjectdtl subjectDtl;

  @OneToMany(targetEntity = TDebitCreditDtl.class, fetch = LAZY, cascade = CascadeType.ALL)
  @JoinColumn(name = "refno", referencedColumnName = "refno")
  private List<TDebitCreditDtl> details;

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }


  public Boolean getPerson() {
    return person;
  }

  public void setPerson(Boolean person) {
    this.person = person;
  }

  public Boolean getShop() {
    return shop;
  }

  public void setShop(Boolean shop) {
    this.shop = shop;
  }

  public Boolean getSubject() {
    return subject;
  }

  public void setSubject(Boolean subject) {
    this.subject = subject;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getOutTradeNo() {
    return outTradeNo;
  }

  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  public String getOutId() {
    return outId;
  }

  public void setOutId(String outId) {
    this.outId = outId;
  }

  public String getReverseFlag() {
    return reverseFlag;
  }

  public void setReverseFlag(String reverseFlag) {
    this.reverseFlag = reverseFlag;
  }

  public TPersondtl getPersonDtl() {
    return personDtl;
  }

  public TShopdtl getShopDtl() {
    return shopDtl;
  }

  public TSubjectdtl getSubjectDtl() {
    return subjectDtl;
  }

  public List<TDebitCreditDtl> getDetails() {
    return details;
  }

  public void setPersonDtl(TPersondtl personDtl) {
    this.personDtl = personDtl;
  }

  public void setShopDtl(TShopdtl shopDtl) {
    this.shopDtl = shopDtl;
  }

  public void setSubjectDtl(TSubjectdtl subjectDtl) {
    this.subjectDtl = subjectDtl;
  }

  public void setDetails(List<TDebitCreditDtl> details) {
    this.details = details;
  }

  public Timestamp getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Timestamp createTime) {
    this.createTime = createTime;
  }

  public Timestamp getEndTime() {
    return endTime;
  }

  public void setEndTime(Timestamp endTime) {
    this.endTime = endTime;
  }

  public String getOperid() {
    return operid;
  }

  public void setOperid(String operid) {
    this.operid = operid;
  }

  public String getOpertype() {
    return opertype;
  }

  public void setOpertype(String opertype) {
    this.opertype = opertype;
  }

  public String getCheckDate() {
    return checkDate;
  }

  public void setCheckDate(String checkDate) {
    this.checkDate = checkDate;
  }

  public Boolean getCheckable() {
    return checkable;
  }

  public void setCheckable(Boolean checkable) {
    this.checkable = checkable;
  }

  public String getSettleDate() {
    return settleDate;
  }

  public void setSettleDate(String settleDate) {
    this.settleDate = settleDate;
  }

  public String getSourceType() {
    return sourceType;
  }

  public void setSourceType(String sourceType) {
    this.sourceType = sourceType;
  }

  public Double sumAmountByAccno(String accno, String subjno,
                                 int balanceFlag, String debitOrCredit) {
    Double debitSum = 0.0;
    Double creditSum = 0.0;
    for (TDebitCreditDtl dtl : getDetails()) {
      if (dtl.getDraccno().equals(accno) && dtl.getDrsubjno().equals(subjno)) {
        debitSum += dtl.getAmount();
      }
      if (dtl.getCraccno().equals(accno) && dtl.getCrsubjno().equals(subjno)) {
        creditSum += dtl.getAmount();
      }
    }
    if ("debit".equals(debitOrCredit)) {
      if (balanceFlag == 2) {
        return -debitSum;
      } else {
        return debitSum;
      }
    } else if ("credit".equals(debitOrCredit)) {
      if (balanceFlag == 1) {
        return -creditSum;
      } else {
        return creditSum;
      }
    } else {
      if (balanceFlag == 2) {
        return -(debitSum - creditSum);
      } else {
        return debitSum - creditSum;
      }
    }
  }
}
