package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TShopaccday;
import com.supwisdom.dlpay.framework.domain.TShopaccdayPK;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface ShopaccdayDao extends JpaRepository<TShopaccday, TShopaccdayPK> {

  @Query(value = "from TShopaccday t where t.accdate=:accdate ")
  List<TShopaccday> getShopaccdayByAccdate(@Param("accdate") String accdate);

  @Query(value = "from TShopaccday t where t.accdate=:accdate and t.shopaccno=:shopaccno ")
  TShopaccday getTShopaccdayById(@Param("accdate") String accdate, @Param("shopaccno") String shopaccno);

  @Modifying(clearAutomatically = true)
  @Query(value = "update TB_SHOPACCDAY set balance=beginbal-dramt+cramt,updtime=:updtime where accdate=:accdate ", nativeQuery = true)
  void updateShopaccdayBalance(@Param("accdate") String accdate,@Param("updtime")String updtime);

  @Query(value = "select sum(balance) as amount from TShopaccday where accdate=:accdate ")
  Double getSumBalance(@Param("accdate") String accdate);

}
