package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.ExistBean;
import com.supwisdom.dlpay.framework.domain.TSubject;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface SubjectDao extends JpaRepository<TSubject, String> {

  @Query(value = "select t.SUBJNO from TB_SUBJECT t left join TB_SUBJECTBAL a on t.SUBJNO=a.SUBJNO where t.ENDFLAG=1 and a.SUBJNO is null ", nativeQuery = true)
  List<String> getNewSubject();

  @Query(value = "select count(t.subjno) as existed from TB_SUBJECT t left join TB_SUBJECTBAL a on t.SUBJNO=a.SUBJNO where t.ENDFLAG=1 and a.SUBJNO is null ", nativeQuery = true)
  ExistBean checkSettleSubject();

  @Query(value = "select a.subjno as accno from TB_SUBJECT a left join (select subjno from TB_SUBJECTDAY where accdate =:accdate ) b on a.subjno=b.subjno where a.subjlevel=1 and b.subjno is null ", nativeQuery = true)
  List<String> getNewSubjnos(@Param("accdate") String accdate);

  @Query(value = "select subjname from TSubject where subjno=:subjno ")
  String getSubjectname(@Param("subjno") String subjno);

  TSubject findBySubjno(String subjno);
}
