package com.supwisdom.dlpay.framework.util;

public class NumberUtil {

  /**
   * 判断是否是非负整数
   *
   * @param str
   * @return 是 -> true;  否 -> false 如 1 -> true; -1 -> false
   */
  public static boolean isDigits(String str) {
    if (null == str || "".equals(str.trim())) return false;
    java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("[0-9]*");
    java.util.regex.Matcher match = pattern.matcher(str.trim());
    return match.matches();
  }

  /**
   * 判断是否是整数（包含正负）
   *
   * @param str
   * @return 是 -> true;  否 -> false  如 -1 -> true; -1.0 -> false
   */
  public static boolean isNumber(String str) {
    if (null == str) return false;
    try {
      Integer.valueOf(str);
      return true;
    } catch (NumberFormatException ex) {
      return false;
    }
  }

  /**
   * 判断是否是数字
   *
   * @param str
   * @return 是 -> true;  否 -> false  如 -1 -> true; asd.1sa -> false
   */
  public static boolean isDecimal(String str) {
    if (null == str) return false;
    try {
      Double.valueOf(str.trim());
      return true;
    } catch (NumberFormatException ex) {
      return false;
    }
  }

  /**
   * 判断是否是金额(包含正负，最多2位小数)
   *
   * @param str
   * @return 是 -> true;  否 -> false  如 -1.10 -> true; -1.011 -> false
   */
  public static boolean isAmount(String str) {
    if (!isDecimal(str)) return false;
    if (str.trim().indexOf(".") != -1) {
      String suffix = str.trim().substring(str.trim().indexOf(".") + 1);
      if (suffix.length() > 2) return false; //小数位多余2位
    }
    return true;
  }

}
