package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.api.dao.SourceTypeDao;
import com.supwisdom.dlpay.api.domain.TSourceType;
import com.supwisdom.dlpay.framework.dao.DictionaryDao;
import com.supwisdom.dlpay.framework.domain.TDictionary;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.service.DictionaryDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

@Service
public class DictionaryDataServiceImpl implements DictionaryDataService {
  @Autowired
  private SourceTypeDao sourceTypeDao;
  @Autowired
  private DictionaryDao dictionaryDao;

  @Override
  public HashMap<String, Object> getSystemAllSourcetype() {
    HashMap<String, Object> result = new HashMap<>(0);
    List<TSourceType> list = sourceTypeDao.findAll();
    if (!StringUtil.isEmpty(list)) {
      for (TSourceType tst : list) {
        result.put(tst.getSourceType(), tst.getPaydesc());
      }
    }
    return result;
  }

  @Override
  public HashMap<String, Object> getDictionaryByDicttype(int dicttype) {
    HashMap<String, Object> result = new HashMap<>(0);
    List<TDictionary> list = dictionaryDao.findAllByDicttype(dicttype);
    if (!StringUtil.isEmpty(list)) {
      for (TDictionary dict : list) {
        result.put(dict.getDictval() == null ? "" : dict.getDictval(), dict.getDictcaption());
      }
    }
    return result;
  }
}
