package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.api.dao.PersondtlDao;
import com.supwisdom.dlpay.api.dao.ShopdtlDao;
import com.supwisdom.dlpay.api.domain.TPersondtl;
import com.supwisdom.dlpay.api.domain.TShopdtl;
import com.supwisdom.dlpay.framework.dao.DictionaryDao;
import com.supwisdom.dlpay.framework.dao.ShopDao;
import com.supwisdom.dlpay.framework.dao.TranscodeDao;
import com.supwisdom.dlpay.framework.domain.TDictionary;
import com.supwisdom.dlpay.framework.domain.TShop;
import com.supwisdom.dlpay.framework.domain.TTranscode;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.bean.ShopdtlSearchBean;
import com.supwisdom.dlpay.system.bean.TreeSelectNode;
import com.supwisdom.dlpay.system.bean.UserdtlSearchBean;
import com.supwisdom.dlpay.system.service.DtlDataService;
import com.supwisdom.dlpay.util.ConstantUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

@Service
public class DtlDataServiceImpl implements DtlDataService {
  @Autowired
  private PersondtlDao persondtlDao;
  @Autowired
  private ShopdtlDao shopdtlDao;
  @Autowired
  private TranscodeDao transcodeDao;
  @Autowired
  private DictionaryDao dictionaryDao;
  @Autowired
  private ShopDao shopDao;

  @Override
  public PageResult<TPersondtl> getPersondtlPage(UserdtlSearchBean searchBean, int pageNo, int pageSize) {
    Pageable pageable = PageRequest.of(pageNo - 1, pageSize, Sort.by(Sort.Direction.DESC, "refno"));
    Page<TPersondtl> page = persondtlDao.findAll(new Specification<TPersondtl>() {
      @Override
      public Predicate toPredicate(Root<TPersondtl> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        List<Predicate> predicates = new ArrayList<>();
        if(!StringUtil.isEmpty(searchBean.getStartAccdate())){
          predicates.add(criteriaBuilder.ge(root.get("accdate").as(Integer.class),Integer.valueOf(DateUtil.unParseToDateFormat(searchBean.getStartAccdate()))));
        }
        if(!StringUtil.isEmpty(searchBean.getEndAccdate())){
          predicates.add(criteriaBuilder.le(root.get("accdate").as(Integer.class),Integer.valueOf(DateUtil.unParseToDateFormat(searchBean.getEndAccdate()))));
        }
        if(!StringUtil.isEmpty(searchBean.getStartTransdate())){
          predicates.add(criteriaBuilder.ge(root.get("transdate").as(Integer.class),Integer.valueOf(DateUtil.unParseToDateFormat(searchBean.getStartTransdate()))));

        }
        if(!StringUtil.isEmpty(searchBean.getEndTransdate())){
          predicates.add(criteriaBuilder.le(root.get("transdate").as(Integer.class),Integer.valueOf(DateUtil.unParseToDateFormat(searchBean.getEndTransdate()))));
        }
        if(!StringUtil.isEmpty(searchBean.getPersonname())){
          predicates.add(criteriaBuilder.like(root.get("userName").as(String.class), "%" + searchBean.getPersonname().trim() + "%"));
        }
        if(!StringUtil.isEmpty(searchBean.getSourcetype())){
          predicates.add(criteriaBuilder.equal(root.get("sourceType").as(String.class), searchBean.getSourcetype().trim()));
        }
        if(!StringUtil.isEmpty(searchBean.getTradeflag())){
          predicates.add(criteriaBuilder.equal(root.get("tradeflag").as(String.class), searchBean.getTradeflag().trim()));
        }
        if(!StringUtil.isEmpty(searchBean.getTranscode())){
          predicates.add(criteriaBuilder.equal(root.get("transcode").as(String.class), searchBean.getTranscode().trim()));
        }
        if(!StringUtil.isEmpty(searchBean.getStatus())){
          predicates.add(criteriaBuilder.equal(root.get("status").as(String.class), searchBean.getStatus().trim()));
        }
        return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
      }
    }, pageable);
    return new PageResult<>(page);
  }

  @Override
  public PageResult<TShopdtl> getShopdtlPage(ShopdtlSearchBean searchBean, int pageNo, int pageSize) {
    Pageable pageable = PageRequest.of(pageNo - 1, pageSize, Sort.by(Sort.Direction.DESC, "refno"));
    Page<TShopdtl> page = shopdtlDao.findAll(new Specification<TShopdtl>() {
      @Override
      public Predicate toPredicate(Root<TShopdtl> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        List<Predicate> predicates = new ArrayList<>();
        if(!StringUtil.isEmpty(searchBean.getStartAccdate())){
          predicates.add(criteriaBuilder.ge(root.get("accdate").as(Integer.class),Integer.valueOf(DateUtil.unParseToDateFormat(searchBean.getStartAccdate()))));
        }
        if(!StringUtil.isEmpty(searchBean.getEndAccdate())){
          predicates.add(criteriaBuilder.le(root.get("accdate").as(Integer.class),Integer.valueOf(DateUtil.unParseToDateFormat(searchBean.getEndAccdate()))));
        }
        if(!StringUtil.isEmpty(searchBean.getStartTransdate())){
          predicates.add(criteriaBuilder.ge(root.get("transdate").as(Integer.class),Integer.valueOf(DateUtil.unParseToDateFormat(searchBean.getStartTransdate()))));

        }
        if(!StringUtil.isEmpty(searchBean.getEndTransdate())){
          predicates.add(criteriaBuilder.le(root.get("transdate").as(Integer.class),Integer.valueOf(DateUtil.unParseToDateFormat(searchBean.getEndTransdate()))));
        }
        if(!StringUtil.isEmpty(searchBean.getShopname())){
          predicates.add(criteriaBuilder.like(root.get("shopname").as(String.class), "%" + searchBean.getShopname().trim() + "%"));
        }
        if(!StringUtil.isEmpty(searchBean.getShopaccno())){
          predicates.add(criteriaBuilder.equal(root.get("shopaccno").as(String.class), searchBean.getShopaccno().trim()));
        }
        if(!StringUtil.isEmpty(searchBean.getSourcetype())){
          predicates.add(criteriaBuilder.equal(root.get("sourceType").as(String.class), searchBean.getSourcetype().trim()));
        }
        if(!StringUtil.isEmpty(searchBean.getTradeflag())){
          predicates.add(criteriaBuilder.equal(root.get("tradeflag").as(String.class), searchBean.getTradeflag().trim()));
        }
        if(!StringUtil.isEmpty(searchBean.getTranscode())){
          predicates.add(criteriaBuilder.equal(root.get("transcode").as(String.class), searchBean.getTranscode().trim()));
        }
        if(!StringUtil.isEmpty(searchBean.getStatus())){
          predicates.add(criteriaBuilder.equal(root.get("status").as(String.class), searchBean.getStatus().trim()));
        }
        return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
      }
    }, pageable);
    return new PageResult<>(page);
  }

  @Override
  public List<TTranscode> getAllTranscodes(){
    return transcodeDao.findAll();
  }

  @Override
  public List<TDictionary> getAllDtlStatus(){
    List<TDictionary> list = dictionaryDao.findAllByDicttype(ConstantUtil.DICTTYPE_NO2);
    if(!StringUtil.isEmpty(list)){
      return list;
    }
    return new ArrayList<>(0);
  }

  @Override
  public List<TreeSelectNode> getTreeSelectShops() {
    List<TShop> shoplist = shopDao.getNormalShops();
    if (StringUtil.isEmpty(shoplist)) {
      return new ArrayList<>(0);
    }
    return getShopSelectTree(shoplist, 0);
  }

  private List<TreeSelectNode> getShopSelectTree(List<TShop> shoplist, Integer fshopid) {
    List<TreeSelectNode> result = new ArrayList<>(0);
    for (TShop shop : shoplist) {
      if (fshopid.equals(shop.getFshopid())) {
        TreeSelectNode node = new TreeSelectNode();
        node.setId(String.valueOf(shop.getShopid()));
        if(!StringUtil.isEmpty(shop.getShopaccno())){
          node.setId(shop.getShopaccno()); //替换商户账号
        }
        node.setName(shop.getShopname());
        node.setOpen(StringUtil.isEmpty(shop.getShopaccno()));
        node.setChecked(false);
        node.setAccno(shop.getShopaccno());
        List<TreeSelectNode> children = getShopSelectTree(shoplist, shop.getShopid());
        if(null!=children && children.size()>0){
          node.setChildren(children);
        }else{
          node.setChildren(null);
        }
        result.add(node);
      }
    }
    return result;
  }
}
