package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TShop;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;

import javax.persistence.LockModeType;
import java.util.List;

/**
 * Created by shuwei on 2019/4/15.
 */
public interface ShopDao extends JpaRepository<TShop, Integer> {
    TShop getByThirdUniqueIdenty(String thirdUniqueIdenty);

    @Lock(LockModeType.PESSIMISTIC_WRITE)
    @Query("select a from TShop a where a.thirdUniqueIdenty=?1")
    TShop getByThirdUniqueIdentyForUpdate(String thirdUniqueIdenty);

    TShop getTShopByShopid(Integer shopid);

    TShop getTShopByShopaccno(String shopaccno);

    @Query("from TShop where status='normal' and fshopid=?1 ")
    List<TShop> getChildShopsByShopid(Integer shopid);

    @Query(value = "select count(t.shopid) from TB_SHOP t where t.status='normal' and t.shopname=?1 and t.fshopid=?2 and t.shopid!=?3", nativeQuery = true)
    long checkShopnameExist(String shopname, int fshopid, int oldShopid);

    @Query("from TShop where status='normal' order by shopid asc ")
    List<TShop> getNormalShops();
}
