package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.api.dao.AccountDao;
import com.supwisdom.dlpay.api.dao.PersonDao;
import com.supwisdom.dlpay.api.domain.TAccount;
import com.supwisdom.dlpay.api.domain.TPerson;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.bean.PersonParamBean;
import com.supwisdom.dlpay.system.service.UserDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class UserDataServiceImpl implements UserDataService {
    @Autowired
    private PersonDao personDao;
    @Autowired
    private AccountDao accountDao;

    @Override
    public PageResult<TPerson> getPersonsByKey(PersonParamBean param) {
        Pageable pageable = PageRequest.of(param.getPageNo() - 1, param.getPageSize()
                , Sort.by(Sort.Direction.DESC,"lastsaved"));
        if (!StringUtil.isEmpty(param.getName())) {
            return new PageResult<>(personDao.findAllByNameContaining(param.getName(), pageable));
        }
        return new PageResult<>(personDao.findAll(pageable));
    }

    @Override
    public PageResult<TAccount> getAccountsByKey(PersonParamBean param) {
        Pageable pageable = PageRequest.of(param.getPageNo() - 1, param.getPageSize());
        if (!StringUtil.isEmpty(param.getName())) {
            return new PageResult<>(accountDao.findAllByAccnameContaining(param.getName(), pageable));
        }
        return new PageResult<>(accountDao.findAll(pageable));
    }
}
