package com.supwisdom.dlpay.api.service

import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

interface ConsumePayService{
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun checkShopPaytype(shopaccno: String, paytype: String, anonymousflag: Boolean? = false): Boolean

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun getPaytypeConfig(paytype: String, shopaccno: String, anonymousflag: Boolean? = false, ignoreStatus: Boolean? = false): Map<String, String?>

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun getUserdtlExtendParamMap(refno: String): Map<String, String>
}