package com.supwisdom.dlpay.api.service

import com.supwisdom.dlpay.api.PersonTransBuilder
import com.supwisdom.dlpay.api.domain.TAccount
import com.supwisdom.dlpay.api.domain.TUserdtl
import com.supwisdom.dlpay.framework.domain.TFeetypeConfig
import com.supwisdom.dlpay.framework.domain.TShopacc
import com.supwisdom.dlpay.framework.domain.TSubject
import com.supwisdom.dlpay.framework.domain.TTranstype
import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

interface AccountUtilServcie {

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun readAccountForUpdateNowait(userid: String): TAccount


    fun readAccount(userid: String): TAccount

    fun readShopAcc(shopId: Int): TShopacc

    fun readSubject(subjno: String): TSubject

    fun readFeetype(feetype: String, paytype: String): TFeetypeConfig
}

interface PersonBalancePayService {

    /**
     * 一步完成交易
     */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun process(builder: PersonTransBuilder): TUserdtl

    /**
     * 两步交易，交易初始化方法，检查交易参数，记录交易流水
     */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun init(builder: PersonTransBuilder): TUserdtl

    /**
     * 两步交易，完成交易过程，包括更新交易状态（成功、失败），更新借贷双方余额
     */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun finish(paydtl: TUserdtl, status: String, businessData: Map<String, String>?): TUserdtl

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun finish(refno: String, status: String, businessData: Map<String, String>?): TUserdtl

    /**
     * 两步交易，交易过程中判断交易状态，并更新交易状态为 wip
     * 如果交易记录被锁，立刻抛出异常
     * @throws TransactionProcessException
     */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun wip(paydtl: TUserdtl): TUserdtl

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun wip(refno: String): TUserdtl

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun wip(builder: PersonTransBuilder): TUserdtl

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun finish(builder: PersonTransBuilder): TUserdtl

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun getUserdtlForUpdateNowait(refno: String): TUserdtl

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun getUserdtlByBillnoForUpdateNowait(billno: String, shopaccno: String): TUserdtl
}