package com.supwisdom.dlpay.api

import com.supwisdom.dlpay.api.service.AccountUtilServcie
import com.supwisdom.dlpay.api.service.PersonBalancePayService

class PersonTranactionBuilder(val parent: TransactionBuilder) {
    var userid: String = ""
    var userName: String = ""
    var amount: Double = 0.0
    var summary: String = ""
    var oppositeAccno: String = ""
    var oppositeName: String = ""
    var oppositeType: String = ""

    fun and(): TransactionBuilder {
        return parent
    }
}

class ShopTransactionBuilder(val parent: TransactionBuilder) {
    var shopaccno: String = ""
    var shopname: String = ""
    var amount: Double = 0.0
    var summary: String = ""
    var oppositeAccno: String = ""
    var oppositeName: String = ""
    var oppositeType: String = ""

    fun and(): TransactionBuilder {
        return parent
    }
}

class SubjectTransactionBuilder(val parent: TransactionBuilder) {
    var subjno: String = ""
    var subjName: String = ""
    var amount: Double = 0.0
    var summary: String = ""

    fun and(): TransactionBuilder {
        return parent
    }
}

// 在 constructor 中加入 service 接口
class TransactionBuilder {
    private lateinit var personBuilder: PersonTranactionBuilder
    private lateinit var shopBuilder: ShopTransactionBuilder
    private lateinit var subjectBuilder: SubjectTransactionBuilder

    var transDate: String = ""
    var transTime: String = ""
    var transCode: Int = 0 //交易码,各明细流水统一
    var refno: String = ""
    var outtradeno:String="" //第三方流水号
    val extendMap = mutableMapOf<String, String>() //存调第三方需要的参数信息，存数据库 TB_USERDTL_BUSINESS
    val resultMap = mutableMapOf<String, String>() //存调第三方结果数据

    fun person(): PersonTranactionBuilder {
        return PersonTranactionBuilder(this).also {
            this.personBuilder = it
        }
    }

    fun shop(): ShopTransactionBuilder {
        return ShopTransactionBuilder(this).also {
            this.shopBuilder = it
        }
    }

    fun subject(): SubjectTransactionBuilder {
        return SubjectTransactionBuilder(this).also {
            this.subjectBuilder = it
        }
    }

    fun init(transactionService: PersonBalancePayService) {

    }
}

class TransactionExample {
    companion object {
        fun example(accountUtilServcie: AccountUtilServcie,
                    service: PersonBalancePayService,
                    userid: String, shopid: Int, amount: Int, manageFee: Int,
                    transDate: String, transTime: String) {

            val person = accountUtilServcie.readAccount(userid)
            val shop = accountUtilServcie.readShopAcc(shopid)

            val builder = TransactionBuilder().apply {
                this.transDate = transDate
                this.transTime = transTime
                this.transCode = 3001
            }.person().apply {
                this.userid = userid // 可以再优化，直接用 person 对象
                this.userName = person.accname
                this.amount = (amount + manageFee) / 100.0 // 金额考虑减和加
                this.summary = "POS消费"
            }.and().shop().apply {
                this.shopaccno = shop.shopaccno  // 可以再优化，直接用 shop 对象
                this.shopname = shop.shopname
                this.amount = amount / 100.0 // 金额考虑减和加
                this.summary = "POS消费"
            }.and()
            if (manageFee > 0) {
                builder.subject().apply {
                    val subject = accountUtilServcie.readSubject("2001")
                    this.subjno = subject.subjno
                    this.subjName = subject.subjname
                    this.amount = manageFee / 100.0 // 金额考虑减和加
                    this.summary = "POS消费搭伙费"
                }
            }
            builder.init(service)

        }
    }
}