package com.supwisdom.dlpay.consume.dao;

import com.supwisdom.dlpay.consume.domain.TTransdtl;
import com.supwisdom.dlpay.framework.data.VoucherTemp;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Repository
public interface TransdtlDao extends JpaRepository<TTransdtl, String> {
  @Query(value="select a.drsubjno,a.crsubjno,a.summary,t.shopaccno,count(t.refno) as transcnt,sum(t.paidamt) as transamt " +
      "from tb_transdtl t left join tb_transtype a on t.transtype=a.transtype " +
      "where t.status='success' and t.accdate=:settledate " +
      "group by a.drsubjno,a.crsubjno,a.summary,t.shopaccno ", nativeQuery = true)
  List<VoucherTemp> getVouhcerData(@RequestParam("settledate") String settledate);

  @Query(value="select a.drsubjno,a.crsubjno,a.summary,t.shopaccno,count(t.refno) as transcnt,sum(t.feeamt) as transamt " +
      "from tb_transdtl t left join tb_feetype_config a on t.feetype=a.feetype and t.paytype=a.paytype " +
      "where t.status='success' and t.feetype!='none' and t.accdate=:settledate " +
      "group by a.drsubjno,a.crsubjno,a.summary,t.shopaccno ", nativeQuery = true)
  List<VoucherTemp> getFeeVoucherData(@RequestParam("settledate") String settledate);

  TTransdtl getByOuttradenoAndStatus(String outtradeno,String status);

  @Query(value = " select to_char(sysdate,'yyyyMMddhh24missSSS')||to_char(SEQ_REFNO.nextval,'FM0000000') as billno from dual ",nativeQuery = true)
  String getReno();

  @Query(value = " select to_char(CURRENT_TIMESTAMP,'yyyyMMddhh24missSS')||to_char(nextval('SEQ_REFNO'),'FM0000000') as billno ",nativeQuery = true)
  String getRenoPG();
}
