package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TSettlectl;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.annotation.RequestParam;

import javax.persistence.LockModeType;

@Repository
public interface SettleCtlDao extends JpaRepository<TSettlectl, Integer> {
  @Lock(value = LockModeType.PESSIMISTIC_FORCE_INCREMENT)
  TSettlectl findByBooksetno(Integer booksetno);

  @Query(value = "update TB_SETTLECTL set PERIOD_YEAR=:peridyear,PERIOD_MONTH=:peridmonth where BOOKSETNO=1 ", nativeQuery = true)
  void updateSettlePeriod(@RequestParam("peridyear") int peridyear, @RequestParam("peridmonth") int peridmonth);

}
