package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.domain.TTaskLock;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.web.bind.annotation.RequestParam;

import javax.persistence.LockModeType;

@Repository
public interface TaskLockDao extends JpaRepository<TTaskLock, String> {

  @Lock(LockModeType.PESSIMISTIC_FORCE_INCREMENT)
  @Query("select a from TTaskLock a where a.taskcode=:taskcode")
  TTaskLock getTaskLockWithLock(@RequestParam("taskcode") String taskcode);

  @Query(value = "select  to_char(sysdate,'yyyymmdd') as hostdate,to_char(sysdate,'hh24miss') as hosttime,to_char(sysdate,'yyyymmddhh24miss') as hostdatetime, sysdate from dual", nativeQuery = true)
  SystemDateTime getOracleDatetime();
}
