package com.supwisdom.dlpay.framework.service.impl;

import com.supwisdom.dlpay.framework.dao.TaskLockDao;
import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.domain.TTaskLock;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

@Service
public class SystemUtilServiceImpl implements SystemUtilService {
  @PersistenceContext
  private EntityManager entityManager;
  @Autowired
  private TaskLockDao taskLockDao;

  /**
   * 获取oracle数据库时间
   */
  private SystemDateTime getOracleDatetime() {
    SystemDateTime systemDateTime = taskLockDao.getOracleDatetime();
    return systemDateTime;
  }

  @Override
  public SystemDateTime getSysdatetime() {
    return getOracleDatetime();
  }

  @Override
  public TTaskLock updateTaskLock(TTaskLock lock){
    return taskLockDao.save(lock);
  }

  @Override
  public TTaskLock doLockTask(String taskcode, Integer minRecover, String remark) {
    if (null == minRecover) minRecover = 10; //默认10分钟
    String hostdatetime = getSysdatetime().getHostdatetime(); //yyyyMMddHHmmss
    TTaskLock lock = taskLockDao.getTaskLockWithLock(taskcode);
    if (lock != null) {
      if (lock.getTaskstatus().intValue() == 1 && DateUtil.compareDatetime(DateUtil.getNewTime(hostdatetime, -60 * minRecover), lock.getTasktime()) < 0) {
        // 被锁，正在执行操作
        return null;
      } else {
        lock.setTaskstatus(1);
        lock.setTasktime(hostdatetime);
        taskLockDao.save(lock);
        return lock;
      }
    } else {
      lock = new TTaskLock();
      lock.setTaskcode(taskcode);
      lock.setTaskstatus(1);
      lock.setTasktime(hostdatetime);
      lock.setRemark(remark);
      taskLockDao.save(lock);
    }
    return lock;
  }
}
