package com.supwisdom.dlpay.api.controller

import com.supwisdom.dlpay.api.bean.ModifyUserParam
import com.supwisdom.dlpay.api.bean.OpenUserParam
import com.supwisdom.dlpay.api.bean.QueryUserParam
import com.supwisdom.dlpay.api.service.UserService
import com.supwisdom.dlpay.exception.RequestParamCheckException
import com.supwisdom.dlpay.exception.TransactionException
import com.supwisdom.dlpay.framework.ResponseBodyBuilder
import com.supwisdom.dlpay.framework.service.CommonService
import com.supwisdom.dlpay.framework.util.TradeErrorCode
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.PostMapping
import org.springframework.web.bind.annotation.RequestBody
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.RestController
import java.net.URLDecoder
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse

@RestController
@RequestMapping("/api/user")
class UserAPIController {
    @Autowired
    private lateinit var useService: UserService
    @Autowired
    private lateinit var commonService: CommonService

    @PostMapping("/open")
    fun openAccount(@RequestBody param: OpenUserParam, request: HttpServletRequest, response: HttpServletResponse): ResponseEntity<Any> {
        try {
            if (param.checkParam() && param.checkSign(commonService.getAppidSecretByRequest(request))) {
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .fail(TradeErrorCode.REQUEST_SIGN_ERROR, "参数签名错误"))
            }
            useService.findByThirdUniqueIdenty(param.uid).let {
                if (null != it) {
                    return ResponseEntity.ok(ResponseBodyBuilder.create()
                            .fail(TradeErrorCode.REGISTER_USER_EXIST, "该用户唯一号已经注册"))
                }

                param.name = URLDecoder.decode(param.name, Charsets.UTF_8.toString()) //解码
                param.address = param.address?.let { URLDecoder.decode(param.address, Charsets.UTF_8.toString()) }  //解码
                useService.registerUser(param).let {
                    return ResponseEntity.ok(ResponseBodyBuilder.create()
                            .data("userid", it.userid)
                            .data("uid", param.uid)
                            .success())
                }
            }
        } catch (ex: RequestParamCheckException) {
            return ResponseEntity.ok(ResponseBodyBuilder.create()
                    .requestException(ex, "请求参数错误"))
        } catch (et: TransactionException) {
            return ResponseEntity.ok(ResponseBodyBuilder.create()
                    .transException(et, "业务处理错误"))
        }
    }

    @PostMapping("/query")
    fun queryAccount(@RequestBody param: QueryUserParam, request: HttpServletRequest, response: HttpServletResponse): ResponseEntity<Any> {
        try {
            if (param.checkParam() && param.checkSign(commonService.getAppidSecretByRequest(request))) {
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .fail(TradeErrorCode.REQUEST_SIGN_ERROR, "参数签名错误"))
            }

            useService.findByUseridOrThirdUniqueIdenty(param.userid, param.uid).let {
                if (null != it) {
                    val account = useService.findAccountByUserid(it.userid, null)
                    val pointacc = useService.findPointsAccountByUserid(it.userid)
                    return ResponseEntity.ok(ResponseBodyBuilder.create()
                            .data("userid", it.userid)
                            .data("name", it.name)
                            .data("idtype", it.idtype)
                            .data("idno", it.idno)
                            .data("mobile", it.mobile)
                            .data("email", it.email)
                            .data("status", it.status)
                            .data("balance", account.let {
                                if (null == it) {
                                    0.0
                                } else {
                                    it.availbal
                                }
                            }) //账户余额
                            .data("points", pointacc.let {
                                if (null == it) {
                                    0
                                } else {
                                    it.points
                                }
                            }) //积分
                            .success())
                }

                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .fail(TradeErrorCode.ACCOUNT_NOT_EXISTS, "账户不存在"))
            }
        } catch (ex: RequestParamCheckException) {
            return ResponseEntity.ok(ResponseBodyBuilder.create()
                    .requestException(ex, "请求参数错误"))
        } catch (et: TransactionException) {
            return ResponseEntity.ok(ResponseBodyBuilder.create()
                    .transException(et, "业务处理错误"))
        }
    }

    @PostMapping("/modify")
    fun modifyAccount(@RequestBody param: ModifyUserParam, request: HttpServletRequest, response: HttpServletResponse): ResponseEntity<Any> {
        try {
            if (param.checkParam() && param.checkSign(commonService.getAppidSecretByRequest(request))) {
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .fail(TradeErrorCode.REQUEST_SIGN_ERROR, "参数签名错误"))
            }
            useService.findByUseridOrThirdUniqueIdenty(param.userid, param.uid)?.let {
                param.name = param.name?.let { URLDecoder.decode(param.name, Charsets.UTF_8.toString()) } //解码
                param.address = param.address?.let { URLDecoder.decode(param.address, Charsets.UTF_8.toString()) } //解码
                if (useService.modifyUserInfo(it, param)) {
                    return ResponseEntity.ok(ResponseBodyBuilder.create()
                            .success("修改成功"))
                } else {
                    return ResponseEntity.ok(ResponseBodyBuilder.create()
                            .fail(TradeErrorCode.BUSINESS_DEAL_ERROR, "账户信息修改失败"))
                }
            }

            return ResponseEntity.ok(ResponseBodyBuilder.create()
                    .fail(TradeErrorCode.ACCOUNT_NOT_EXISTS, "账户不存在"))
        } catch (ex: RequestParamCheckException) {
            return ResponseEntity.ok(ResponseBodyBuilder.create()
                    .requestException(ex, "请求参数错误"))
        } catch (et: TransactionException) {
            return ResponseEntity.ok(ResponseBodyBuilder.create()
                    .transException(et, "业务处理错误"))
        }
    }


}