package com.supwisdom.dlpay.api.service.impl

import com.supwisdom.dlpay.api.bean.ModifyUserParam
import com.supwisdom.dlpay.api.bean.OpenUserParam
import com.supwisdom.dlpay.api.dao.AccountDao
import com.supwisdom.dlpay.api.dao.PersonDao
import com.supwisdom.dlpay.api.dao.PersonIdentityDao
import com.supwisdom.dlpay.api.dao.PointsAccountDao
import com.supwisdom.dlpay.api.domain.TAccount
import com.supwisdom.dlpay.api.domain.TPerson
import com.supwisdom.dlpay.api.domain.TPersonIdentity
import com.supwisdom.dlpay.api.domain.TPointsAccount
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.api.service.UserService
import com.supwisdom.dlpay.exception.TransactionProcessException
import com.supwisdom.dlpay.framework.util.*
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

/**
 * Created by shuwei on 2019/4/15.
 */
@Service
class UserServiceImpl : UserService {
    @Autowired
    private lateinit var personDao: PersonDao
    @Autowired
    private lateinit var accountDao: AccountDao
    @Autowired
    private lateinit var personIdentityDao: PersonIdentityDao
    @Autowired
    private lateinit var pointsAccountDao: PointsAccountDao
    @Autowired
    private lateinit var systemUtilService: SystemUtilService

    override fun registerUser(param: OpenUserParam): TPerson {
        var person = personDao.findByIdentity(param.idtype, param.idno)
        if (null != person && param.name != person.name)
            throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "证件指定用户与请求的用户名不匹配")

        val systemdatetime = systemUtilService.sysdatetime
        if (null == person) {
            person = personDao.save(TPerson().apply {
                name = param.name
                sex = param.sex
                status = TradeDict.STATUS_NORMAL
                idtype = param.idtype
                idno = param.idno
                email = param.email
                tel = param.tel
                mobile = param.mobile
                addr = param.address
                zipcode = param.zipcode
                lastsaved = systemdatetime.hostdatetime
            })
        }

        if (accountDao.findByUseridAndSubjno(person.userid, Subject.SUBJNO_PERSONAL_DEPOSIT) == null) {
            //开户
            TAccount().apply {
                accname = person.name
                subjno = Subject.SUBJNO_PERSONAL_DEPOSIT
                userid = person.userid
                status = person.status
                balance = 0.0
                availbal = 0.0
                frozebal = 0.0
                lowfreeFlag = false
                lowfreeLimit = lowfreeLimit
                daylimit = daylimit
                maxbal = systemUtilService.getSysparaValueAsDouble(SysparaUtil.SYSPARAID_NO1, SysparaUtil.SYSPARA_NO1_DEFAULT)
                lasttransdate = systemdatetime.hostdate
                lastdayTransamt = 0.0
                lastdayDpsamt = 0.0
                opendate = systemdatetime.hostdate
                tac = this.generateTac()
                accountDao.save(this)
            }
        }
        personIdentityDao.save(TPersonIdentity().apply {
            thirdUid = param.uid
            this.person = person
            status = person.status
            lossflag = 0
            lockflag = 0
            createtime = systemdatetime.hostdatetime
        }) //保存绑定关系

        return person
    }

    override fun findByThirdUniqueIdenty(thirdUniqueIdenty: String): TPerson? {
        return personIdentityDao.getByThirdUid(thirdUniqueIdenty)?.let { it.person }
    }

    override fun findByUseridOrThirdUniqueIdenty(userid: String?, thirdUniqueIdenty: String?): TPerson? {
        return if (!StringUtil.isEmpty(userid)) {
            personDao.findByUserid(userid)
        } else {
            personIdentityDao.getByThirdUid(thirdUniqueIdenty)?.let { it.person }
        }
    }

    override fun modifyUserInfo(person: TPerson, param: ModifyUserParam): Boolean {
        if (!StringUtil.isEmpty(param.name) && param.name != person.name) {
            person.name = param.name
            accountDao.findByUseridAndSubjno(person.userid, Subject.SUBJNO_PERSONAL_DEPOSIT)?.let {
                it.accname = param.name
                accountDao.save(it)
            }
        }
        if (!StringUtil.isEmpty(param.sex)) person.sex = param.sex
        if (!StringUtil.isEmpty(param.idno)) {
            person.idtype = param.idtype
            person.idno = param.idno
        }
        if (!StringUtil.isEmpty(param.mobile)) person.mobile = param.mobile
        if (!StringUtil.isEmpty(param.tel)) person.tel = param.tel
        if (!StringUtil.isEmpty(param.email)) person.email = param.email
        if (!StringUtil.isEmpty(param.address)) person.addr = param.address
        if (!StringUtil.isEmpty(param.zipcode)) person.zipcode = param.zipcode
        personDao.save(person)
        return true
    }

    override fun findPersonByUserid(userid: String): TPerson? {
        return personDao.findByUserid(userid)
    }

    override fun findAccountByUserid(userid: String, subjno: String?): TAccount? {
        return if (!StringUtil.isEmpty(subjno)) {
            accountDao.findByUseridAndSubjno(userid, subjno)
        } else {
            accountDao.findByUseridAndSubjno(userid, Subject.SUBJNO_PERSONAL_DEPOSIT)
        }
    }

    override fun findPointsAccountByUserid(userid: String): TPointsAccount? {
        return pointsAccountDao.findByUserid(userid)
    }

    override fun findPersonIdentity(thirdUniqueIdenty: String): TPersonIdentity? {
        return personIdentityDao.getByThirdUid(thirdUniqueIdenty)
    }

    override fun findPersonByIdentityCheckStatus(thirdUniqueIdenty: String): TPerson {
        personIdentityDao.getByThirdUid(thirdUniqueIdenty).let {
            if (null != it) {
                if (TradeDict.STATUS_NORMAL != it.status) {
                    throw TransactionProcessException(TradeErrorCode.PERSON_STATUS_ERROR, "账户状态异常")
                }
                if (1 == it.lossflag) {
                    throw TransactionProcessException(TradeErrorCode.ACCOUNT_IS_LOSS, "账户已挂失")
                }
                if (1 == it.lockflag) {
                    throw TransactionProcessException(TradeErrorCode.ACCOUNT_IS_LOCKED, "账户已冻结")
                }

                if (null != it.person) {
                    return it.person
                } else {
                    throw TransactionProcessException(TradeErrorCode.ACCOUNT_NOT_EXISTS, "账户不存在")
                }
            }

            throw TransactionProcessException(TradeErrorCode.ACCOUNT_NOT_EXISTS, "账户不存在")
        }
    }

}