package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_USERDTL_DEBITCREDIT")
@IdClass(TDebitCreditDtlPK.class)
public class TDebitCreditDtl {

  @Id
  @Column(name = "REFNO", nullable = false, length = 32)
  private String refno;

  @Id
  @Column(name = "SEQNO", nullable = false, precision = 2)
  private Integer seqno;

  @Column(name = "accdate", nullable = false, length = 8)
  private String accdate;

  @Column(name = "DRSUBJNO", length = 10)
  private String drsubjno; //借方科目

  @Column(name = "DRACCNO", length = 32)
  private String draccno;  //借方账号

  @Column(name = "AMOUNT", precision = 9, scale = 2)
  private Double amount; //金额

  @Column(name = "CRSUBJNO", length = 10)
  private String crsubjno; //贷方科目

  @Column(name = "CRACCNO", length = 32)
  private String craccno;  //贷方账号

  @Column(name = "SUMMARY", length = 240)
  private String summary;  //摘要


  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public Integer getSeqno() {
    return seqno;
  }

  public void setSeqno(Integer seqno) {
    this.seqno = seqno;
  }

  public String getDrsubjno() {
    return drsubjno;
  }

  public void setDrsubjno(String drsubjno) {
    this.drsubjno = drsubjno;
  }

  public String getDraccno() {
    return draccno;
  }

  public void setDraccno(String draccno) {
    this.draccno = draccno;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public String getCrsubjno() {
    return crsubjno;
  }

  public void setCrsubjno(String crsubjno) {
    this.crsubjno = crsubjno;
  }

  public String getCraccno() {
    return craccno;
  }

  public void setCraccno(String craccno) {
    this.craccno = craccno;
  }

  public String getSummary() {
    return summary;
  }

  public void setSummary(String summary) {
    this.summary = summary;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }
}
