package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.framework.domain.*;
import com.supwisdom.dlpay.framework.security.OperUtil;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.system.bean.FunctionSearchBean;
import com.supwisdom.dlpay.system.bean.LogBean;
import com.supwisdom.dlpay.system.bean.OperatorSearchBean;
import com.supwisdom.dlpay.system.service.OperatorService;
import com.supwisdom.dlpay.system.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Controller
@RequestMapping("/operator")
public class OperatorController {
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private RoleService roleService;

    @GetMapping("/index")
    @PreAuthorize("hasPermission('/operator/index','')")
    public String indexView(Model model) {
        return "system/operator/index";
    }

    @GetMapping("/list")
    @ResponseBody
    public PageResult<TOperator> getDataList(@RequestParam("page") Integer pageNo,
                                             @RequestParam("limit") Integer pageSize,
                                             @RequestParam(value = "searchkey", required = false) String searchKey,
                                             @RequestParam(value = "searchvalue", required = false) String searchValue) {
        try {

            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            OperatorSearchBean searchBean = new OperatorSearchBean();
            if (!StringUtil.isEmpty(searchValue)) {
                if ("opercode".equals(searchKey)) {
                    searchBean.setOpercode(searchValue.trim());
                } else if ("opername".equals(searchKey)) {
                    searchBean.setOpername(searchValue.trim());
                } else if ("mobile".equals(searchValue.trim())) {
                    searchBean.setMobile(searchValue.trim());
                }
            }
            return operatorService.getOperatorsByPage(pageNo, pageSize, searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/load4add")
    @PreAuthorize("hasPermission('/operator/load4add','')")
    public String load4addOperator(Model model) {
        model.addAttribute("roles", roleService.findAllRoles());
        return "system/operator/operator";
    }

    @GetMapping("/checkopercode")
    @ResponseBody
    public JsonResult checkOpercode(@RequestParam("opercode") String opercode,
                                    @RequestParam(value = "operid", required = false) String operid) {
        if (operatorService.checkOpercodeExists(opercode, operid)) {
            return JsonResult.error("账号重复");
        }
        return JsonResult.ok("success");
    }

    @PostMapping("/getoperatorrole")
    @ResponseBody
    public JsonResult getoperatorrole(@RequestParam(value = "operid") String operid) {
        List<TOperRole> roles = operatorService.getOperRoleByOperId(operid);
        JsonResult ret = JsonResult.ok("success");
        ret.put("roles", roles);
        return ret;
    }

    @PostMapping("/add")
    @PreAuthorize("hasPermission('/operator/add','')")
    @ResponseBody
    public JsonResult add(@RequestParam("operid") String operid, @RequestParam("opercode") String opercode,
                          @RequestParam("opername") String opername, @RequestParam("sex") String sex,
                          @RequestParam("mobile") String mobile, @RequestParam("email") String email,
                          @RequestParam("roleId") String roleId, Model map) {
        if (operatorService.checkOpercodeExists(opercode, operid)) {
            return JsonResult.error("账号重复");
        }
        TOperator operator = new TOperator();
        operator.setOpername(opername);
        operator.setOpercode(opercode);
        operator.setOperid(operid);
        operator.setMobile(mobile);
        operator.setEmail(email);
        operator.setSex(sex);
        boolean ret = operatorService.saveOperator(operator, roleId);
        if (ret) {
            return JsonResult.ok("操作成功");
        } else {
            return JsonResult.error("操作失败");
        }
    }

    @PostMapping("/resetpwd")
    @PreAuthorize("hasPermission('/operator/resetpwd','')")
    @ResponseBody
    public JsonResult resetpwd(@RequestParam("operid") String operid) {
        if (operatorService.resetPwd(operid)) {
            return JsonResult.ok("操作成功，密码重置为123456");
        } else {
            return JsonResult.error("操作失败");
        }
    }

    @PostMapping("/updatestate")
    @PreAuthorize("hasPermission('/operator/updatestate','')")
    @ResponseBody
    public JsonResult updatestate(@RequestParam("operid") String operid, @RequestParam("state") String state) {
        if (operatorService.updateState(operid, state)) {
            return JsonResult.ok("操作成功");
        } else {
            return JsonResult.error("操作失败");
        }
    }

    @GetMapping("/logs")
    public String logs() {
        return "system/operator/logs";
    }

    @GetMapping("/logslist")
    @PreAuthorize("hasPermission('/operator/logslist','')")
    @ResponseBody
    public PageResult<TOperLog> logslist(@RequestParam("page") Integer pageNo,
                                         @RequestParam("limit") Integer pageSize,
                                         @RequestParam(value = "searchkey", required = false) String searchKey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            LogBean searchBean = new LogBean();
            searchBean.setPageNo(pageNo);
            searchBean.setOpername(searchKey);
            searchBean.setPageSize(pageSize);
            return operatorService.getOperLogs(searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/userinfor")
    public String userinfor(ModelMap map) {
        TOperator operator = OperUtil.getCurrentOper();
        if(operator!=null){
            operator = operatorService.getOperatorByCode(operator.getOpercode());
        }
        map.put("user", operator);
        return "system/operator/userinfor";
    }

    @PostMapping("/updateinfor")
    @ResponseBody
    public JsonResult updateinfor(@RequestBody TOperator oper) {
        TOperator operator = OperUtil.getCurrentOper();
        if (oper != null) {
            operator.setSex(oper.getSex());
            operator.setOpername(oper.getOpername());
            operator.setEmail(oper.getEmail());
            operator.setMobile(oper.getMobile());
            operatorService.saveOperator(operator);
        }
        return JsonResult.ok("操作成功");
    }

    @GetMapping("/setpwd")
    public String setpwd(ModelMap map) {
        return "system/operator/setpwd";
    }

    @PostMapping("/dosetpwd")
    @ResponseBody
    public JsonResult dosetpwd(@RequestParam String curpwd,
                               @RequestParam String newpwd, @RequestParam String renewpwd) {
        if (StringUtil.isEmpty(curpwd)
                || StringUtil.isEmpty(newpwd)
                || StringUtil.isEmpty(renewpwd)) {
            return JsonResult.error("参数粗错误");
        }
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        String encpwd = encoder.encode(curpwd);
        TOperator operator = OperUtil.getCurrentOper();
        if (operator == null) {
            return JsonResult.error(401, "登录已过期，请重新登录");
        }
        if (!encoder.matches(curpwd,operator.getPassword())) {
            return JsonResult.error("当前密码错误");
        }
        if (!newpwd.equals(renewpwd)) {
            return JsonResult.error("两次密码不一致");
        }
        if(newpwd.length()<6||newpwd.length()>20){
            return JsonResult.error("密码6~20个字符");
        }
        operator.setOperpwd(encoder.encode(newpwd));
        operatorService.saveOperator(operator);
        return JsonResult.ok("密码修改成功，请重新登录");
    }
}
