package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.api.dao.AccountDao;
import com.supwisdom.dlpay.api.dao.PersonDao;
import com.supwisdom.dlpay.api.dao.PersonIdentityDao;
import com.supwisdom.dlpay.api.dao.PointsAccountDao;
import com.supwisdom.dlpay.api.domain.TAccount;
import com.supwisdom.dlpay.api.domain.TPerson;
import com.supwisdom.dlpay.api.domain.TPersonIdentity;
import com.supwisdom.dlpay.api.domain.TPointsAccount;
import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import com.supwisdom.dlpay.framework.util.*;
import com.supwisdom.dlpay.system.bean.PersonParamBean;
import com.supwisdom.dlpay.system.service.UserDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class UserDataServiceImpl implements UserDataService {
    @Autowired
    private PersonDao personDao;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private PointsAccountDao pointsAccountDao;
    @Autowired
    private SystemUtilService systemUtilService;
    @Autowired
    private PersonIdentityDao personIdentityDao;

    @Override
    public PageResult<TPerson> getPersonsByKey(PersonParamBean param) {
        Pageable pageable = PageRequest.of(param.getPageNo() - 1, param.getPageSize()
                , Sort.by(Sort.Direction.DESC, "lastsaved"));
        if (!StringUtil.isEmpty(param.getName())) {
            return new PageResult<>(personDao.findAllByNameContaining(param.getName(), pageable));
        }
        return new PageResult<>(personDao.findAll(pageable));
    }

    @Override
    public PageResult<TAccount> getAccountsByKey(PersonParamBean param) {
        Pageable pageable = PageRequest.of(param.getPageNo() - 1, param.getPageSize());
        if (!StringUtil.isEmpty(param.getName())) {
            return new PageResult<>(accountDao.findAllByAccnameContaining(param.getName(), pageable));
        }
        return new PageResult<>(accountDao.findAll(pageable));
    }

    @Override
    public PageResult<TPointsAccount> getPointsByKey(PersonParamBean param) {
        Pageable pageable = PageRequest.of(param.getPageNo() - 1, param.getPageSize());
        if (!StringUtil.isEmpty(param.getName())) {
            return new PageResult<>(pointsAccountDao.findAllByNameContaining(param.getName(), pageable));
        }
        return new PageResult<>(pointsAccountDao.findAll(pageable));
    }

    @Override
    public JsonResult saveUser(TPerson person) {
        if (!StringUtil.isEmpty(person.getUserid())) {
            Optional<TPerson> temp = personDao.findById(person.getUserid());
            if (!temp.isPresent()) {
                return JsonResult.error("参数错误");
            }
            TPerson it = temp.get();
            if (!person.getIdno().equals(it.getIdno())
                    || !person.getIdtype().equals(it.getIdtype())) {
                TPerson has = personDao.findByIdentity(person.getIdtype(), person.getIdno());
                if (has != null && !has.getUserid().equals(person.getUserid())) {
                    return JsonResult.error("证件类型、证件号已存在");
                }
            }
            if (!person.getName().equals(it.getName())) {
                TAccount account = accountDao.findByUserid(person.getUserid());
                if (account != null) {
                    account.setAccname(person.getName());
                    accountDao.save(account);
                }
            }
            if (StringUtil.isEmpty(person.getStatus())) {
                person.setStatus(TradeDict.STATUS_NORMAL);
            }
            personDao.save(person);
        } else {
            TPerson has = personDao.findByIdentity(person.getIdtype(), person.getIdno());
            if (has != null) {
                return JsonResult.error("证件类型、证件号已存在");
            }
            SystemDateTime systemDateTime = systemUtilService.getSysdatetime();
            person.setStatus(TradeDict.STATUS_NORMAL);
            person.setLastsaved(systemDateTime.getHostdatetime());
            person = personDao.save(person);

            TAccount account = new TAccount();
            account.setAccname(person.getName());
            account.setSubjno(Subject.SUBJNO_PERSONAL_DEPOSIT);
            account.setUserid(person.getUserid());
            account.setStatus(person.getStatus());
            account.setBalance(0.0);
            account.setAvailbal(0.0);
            account.setFrozebal(0.0);
            account.setLowfreeFlag(false);
            account.setMaxbal(systemUtilService.getSysparaValueAsDouble(SysparaUtil.SYSPARAID_NO1, SysparaUtil.SYSPARA_NO1_DEFAULT));
            account.setLasttransdate(systemDateTime.getHostdate());
            account.setLastdayDpsamt(0.0);
            account.setLastdayTransamt(0.0);
            account.setOpendate(systemDateTime.getHostdate());
            account.setTac(account.generateTac());
            accountDao.save(account);
        }
        return JsonResult.ok("添加成功");
    }

    @Override
    public JsonResult deleteUser(String userid) {
        TAccount account = accountDao.findByUserid(userid);
        if (account != null) {
            if (!TradeDict.STATUS_CLOSED.equals(account.getStatus()) && account.getBalance() != 0) {
                return JsonResult.error("该用户账户未注销且余额不为0，无法删除");
            } else {
                accountDao.delete(account);
            }
        }
        TPointsAccount pointsAccount = pointsAccountDao.findByUserid(userid);
        if (pointsAccount != null) {
            if (pointsAccount.getPoints() != 0) {
                return JsonResult.error("该用户账户积分不为0，无法删除，若要删除请先删除积分账户");
            } else {
                pointsAccountDao.delete(pointsAccount);
            }
        }
        personDao.deleteById(userid);
        return JsonResult.ok("操作成功");
    }

    @Override
    public JsonResult closeAccount(String accno) {
        Optional<TAccount> opt = accountDao.findById(accno);
        if (opt.isPresent()) {
            TAccount acc = opt.get();
            acc.setStatus(TradeDict.STATUS_CLOSED);
            accountDao.save(acc);
            return JsonResult.ok("操作成功");
        } else {
            return JsonResult.error("参数错误");
        }
    }

    @Override
    public JsonResult deletePoint(String userid) {
        Optional<TPointsAccount> pointsAccount = pointsAccountDao.findById(userid);
        if (pointsAccount.isPresent()) {
            pointsAccountDao.delete(pointsAccount.get());
            return JsonResult.ok("操作成功");
        }else {
            return JsonResult.error("参数错误");
        }
    }

    @Override
    public List<TPersonIdentity> getPersonIdentity(String userid) {
        return null;
    }

    @Override
    public PageResult<TPointsAccount> getUserPointDTL(PersonParamBean param) {
        return null;
    }
}
