package com.supwisdom.dlpay.api.dao;

import com.supwisdom.dlpay.api.domain.TAccount;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;

public interface AccountDao extends JpaRepository<TAccount, String> {

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query("select a from TAccount a where a.accno = ?1")
  TAccount getByAccnoForUpdate(String accno);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value ="0")})
  @Query("select a from TAccount a where a.accno = ?1")
  TAccount getByAccnoForUpdateNowait(String accno);

  TAccount findByUserid(String userid);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query("select a from TAccount a where a.userid = ?1")
  TAccount getByUseridForUpdate(String userid);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value = "0")})
  @Query("select a from TAccount a where a.userid = ?1")
  TAccount getByUseridForUpdateNowait(String userid);

  @Query("select a from TAccount a where a.userid = ?1 and a.subjno=?2")
  TAccount findByUseridAndSubjno(String userid, String subjno);
}
