package com.supwisdom.dlpay.api.dao;

import com.supwisdom.dlpay.api.domain.TUserdtl;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;

@Repository
public interface UserdtlDao extends JpaRepository<TUserdtl, String> {
  TUserdtl findByRefno(String refno);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query("select dtl from TUserdtl  dtl where dtl.refno = ?1")
  TUserdtl findByRefnoForUpdate(String refno);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value ="0")})
  @Query("select dtl from TUserdtl  dtl where dtl.refno = ?1")
  TUserdtl findByRefnoForUpdateNowait(String refno);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value ="0")})
  @Query("select dtl from TUserdtl dtl where dtl.outtradeno = ?1 and dtl.shopaccno=?2 ")
  TUserdtl findByBillnoForUpdateNowait(String billno,String shopaccno);
}
