package com.supwisdom.dlpay.api.domain;

import com.supwisdom.dlpay.framework.util.MD5;
import com.supwisdom.dlpay.framework.util.MoneyUtil;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Entity
@Table(name = "TB_ACCOUNT",
    indexes = {@Index(name = "acc_userid_idx", columnList = "userid"),
        @Index(name = "acc_status_idx", columnList = "status"),
        @Index(name = "acc_subjno_uk", unique = true, columnList = "subjno,userid")})
public class TAccount {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "ACCNO", nullable = false, length = 32)
  private String accno; //账号

  @Column(name = "ACCNAME", length = 100)
  private String accname; //账户名

  @Column(name = "SUBJNO", length = 10)
  private String subjno; //科目号

  @Column(name = "USERID", nullable = false, length = 32)
  private String userid; //用户ID

  @Column(name = "STATUS", nullable = false, length = 20)
  private String status; //状态：normal-正常；closed-注销；locked-冻结

  @Column(name = "BALANCE", nullable = false, precision = 15, scale = 2)
  private Double balance; //总余额

  @Column(name = "AVAILBAL", nullable = false, precision = 15, scale = 2)
  private Double availbal; //可用余额

  @Column(name = "FROZEBAL", nullable = false, precision = 15, scale = 2)
  private Double frozebal; //冻结金额

  @Column(name = "LOWFREE_FLAG", nullable = false, precision = 1, scale = 0)
  private Boolean lowfreeFlag; //低额免密开关

  @Column(name = "LOWFREE_LIMIT", precision = 9, scale = 2)
  private Double lowfreeLimit; //免密额度

  @Column(name = "DAY_LIMIT", precision = 9, scale = 2)
  private Double daylimit; // 日累计消费额度

  @Column(name = "MAX_BAL", precision = 15, scale = 2)
  private Double maxbal; // 最大余额限制

  @Column(name = "LAST_TRANSDATE", length = 8)
  private String lasttransdate; //最后交易日期

  @Column(name = "LASTDAY_TRANSAMT", precision = 9, scale = 2)
  private Double lastdayTransamt; //最后一天消费金额

  @Column(name = "LASTDAY_DPSAMT", precision = 9, scale = 2)
  private Double lastdayDpsamt; //最后一天充值金额

  @Column(name = "TAC", length = 32)
  private String tac; //校验

  @Column(name = "OPENDATE", nullable = false, length = 8)
  private String opendate;

  @Column(name = "CLOSEDATE", length = 8)
  private String closedate;

  public TAccount() {
  }

  public TAccount(String accname, String subjno, String userid, String status, Double balance, Double availbal, Double frozebal, Boolean lowfreeFlag, Double lowfreeLimit, Double daylimit, Double maxbal, String lasttransdate, Double lastdayTransamt, Double lastdayDpsamt, String tac, String opendate, String closedate) {
    this.accname = accname;
    this.subjno = subjno;
    this.userid = userid;
    this.status = status;
    this.balance = balance;
    this.availbal = availbal;
    this.frozebal = frozebal;
    this.lowfreeFlag = lowfreeFlag;
    this.lowfreeLimit = lowfreeLimit;
    this.daylimit = daylimit;
    this.maxbal = maxbal;
    this.lasttransdate = lasttransdate;
    this.lastdayTransamt = lastdayTransamt;
    this.lastdayDpsamt = lastdayDpsamt;
    this.tac = tac;
    this.opendate = opendate;
    this.closedate = closedate;
  }

  public String getAccno() {
    return accno;
  }

  public void setAccno(String accno) {
    this.accno = accno;
  }

  public String getAccname() {
    return accname;
  }

  public void setAccname(String accname) {
    this.accname = accname;
  }

  public String getSubjno() {
    return subjno;
  }

  public void setSubjno(String subjno) {
    this.subjno = subjno;
  }

  public String getUserid() {
    return userid;
  }

  public void setUserid(String userid) {
    this.userid = userid;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Double getBalance() {
    return balance;
  }

  public void setBalance(Double balance) {
    this.balance = balance;
  }

  public Double getAvailbal() {
    return availbal;
  }

  public void setAvailbal(Double availbal) {
    this.availbal = availbal;
  }

  public Double getFrozebal() {
    return frozebal;
  }

  public void setFrozebal(Double frozebal) {
    this.frozebal = frozebal;
  }

  public Boolean getLowfreeFlag() {
    return lowfreeFlag;
  }

  public void setLowfreeFlag(Boolean lowfreeFlag) {
    this.lowfreeFlag = lowfreeFlag;
  }

  public Double getLowfreeLimit() {
    return lowfreeLimit;
  }

  public void setLowfreeLimit(Double lowfreeLimit) {
    this.lowfreeLimit = lowfreeLimit;
  }

  public Double getDaylimit() {
    return daylimit;
  }

  public void setDaylimit(Double daylimit) {
    this.daylimit = daylimit;
  }

  public Double getMaxbal() {
    return maxbal;
  }

  public void setMaxbal(Double maxbal) {
    this.maxbal = maxbal;
  }

  public String getLasttransdate() {
    return lasttransdate;
  }

  public void setLasttransdate(String lasttransdate) {
    this.lasttransdate = lasttransdate;
  }

  public Double getLastdayTransamt() {
    return lastdayTransamt;
  }

  public void setLastdayTransamt(Double lastdayTransamt) {
    this.lastdayTransamt = lastdayTransamt;
  }

  public Double getLastdayDpsamt() {
    return lastdayDpsamt;
  }

  public void setLastdayDpsamt(Double lastdayDpsamt) {
    this.lastdayDpsamt = lastdayDpsamt;
  }

  public String getTac() {
    return tac;
  }

  public void setTac(String tac) {
    this.tac = tac;
  }

  public String getOpendate() {
    return opendate;
  }

  public void setOpendate(String opendate) {
    this.opendate = opendate;
  }

  public String getClosedate() {
    return closedate;
  }

  public void setClosedate(String closedate) {
    this.closedate = closedate;
  }

  public String generateTac() {
    String data = this.accno + MoneyUtil.YuanToFen(this.availbal) + MoneyUtil.YuanToFen(this.balance) + MoneyUtil.YuanToFen(this.frozebal);
    return MD5.generatePassword(data, this.accno);
  }

  public boolean tacCheck() {
    String tac_c = generateTac();
    if (tac_c.equalsIgnoreCase(this.tac) || this.tac == null) {
      return true;
    }
    return false;
  }

  public void addAmount(double amount) {
    this.balance = this.balance + amount;
    this.availbal = this.availbal + amount;
    this.tac = this.generateTac();
  }

  public boolean checkOverflow() {
    if (null != this.maxbal && this.maxbal > 0) {
      if (MoneyUtil.moneyCompare(this.balance, this.maxbal) > 0) {
        return true; //超出账户最大值
      }
    }
    return false;
  }

  public boolean checkOverdraft() {
    if (MoneyUtil.moneyCompare(this.balance, 0) < 0) {
      return true; //欠费透支
    }
    return false;
  }

  public boolean checkOverdraft(double limit) {
    if (MoneyUtil.moneyCompare(this.balance, limit) < 0) {
      return true; //余额低于某阀值
    }
    return false;
  }
}
