package com.supwisdom.dlpay.api.domain;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.supwisdom.dlpay.framework.util.StringUtil;

import javax.persistence.*;
import java.util.HashMap;
import java.util.Map;

@Entity
@Table(name = "TB_USERDTL_BUSINESS")
public class TUserdtlBusiness {
  @Id
  @Column(name = "REFNO", nullable = false, length = 32)
  private String refno;

  @Column(name = "JSON_CONTENT", length = 1000)
  private String jsonContent;

  @Transient
  private static final Gson gsonUtil = new Gson();

  public TUserdtlBusiness() {
  }

  public TUserdtlBusiness(String refno, String jsonContent) {
    this.refno = refno;
    this.jsonContent = jsonContent;
  }

  public TUserdtlBusiness(String refno, Map<String, Object> map) {
    this.refno = refno;
    if (null == map || map.isEmpty()) {
      this.jsonContent = "";
    } else {
      this.jsonContent = gsonUtil.toJson(map);
    }
  }

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getJsonContent() {
    return jsonContent;
  }

  public void setJsonContent(String jsonContent) {
    this.jsonContent = jsonContent;
  }

  public Map<String, Object> getContentMap() {
    Map<String, Object> map = new HashMap<>(0);
    if (!StringUtil.isEmpty(this.jsonContent))
      map = gsonUtil.fromJson(this.jsonContent, new TypeToken<Map<String, Object>>() {
      }.getType());
    return map;
  }
}
